/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import java.util.function.Function;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;
import xyz.jpenilla.tabtps.common.config.DisplayConfig;
import xyz.jpenilla.tabtps.common.util.Constants;
import xyz.jpenilla.tabtps.common.util.TranslatableProvider;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ComponentLike;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.event.ClickEvent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.event.HoverEventSource;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.NamedTextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextDecoration;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.Command;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.permission.PredicatePermission;

public final class ToggleDisplayCommands
extends TabTPSCommand {
    public ToggleDisplayCommands(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        super(tabTPS, commands);
    }

    @Override
    public void register() {
        Command.Builder<Commander> toggle = this.commands.rootBuilder().literal("toggle", new String[0]);
        this.commands.register(toggle.literal("tab", new String[0]).senderType(User.TYPE).permission(PredicatePermission.of(user -> this.togglePermission((User<?>)user, DisplayConfig::tabSettings))).commandDescription(RichDescription.richDescription(Messages.COMMAND_TOGGLE_TAB_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::toggleTab));
        this.commands.register(toggle.literal("actionbar", new String[0]).senderType(User.TYPE).permission(PredicatePermission.of(user -> this.togglePermission((User<?>)user, DisplayConfig::actionBarSettings))).commandDescription(RichDescription.richDescription(Messages.COMMAND_TOGGLE_ACTIONBAR_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::toggleActionBar));
        this.commands.register(toggle.literal("bossbar", new String[0]).senderType(User.TYPE).permission(PredicatePermission.of(user -> this.togglePermission((User<?>)user, DisplayConfig::bossBarSettings))).commandDescription(RichDescription.richDescription(Messages.COMMAND_TOGGLE_BOSSBAR_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::toggleBossBar));
    }

    private boolean togglePermission(@NonNull User<?> sender, @NonNull Function<DisplayConfig, DisplayConfig.DisplaySettings> function) {
        return this.tabTPS.findDisplayConfig(sender).map(config -> ((DisplayConfig.DisplaySettings)function.apply((DisplayConfig)config)).allow()).orElse(false);
    }

    private void toggleTab(@NonNull CommandContext<User<?>> context) {
        User<?> user = context.sender();
        if (user.tab().enabled()) {
            user.tab().stopDisplay();
            user.tab().enabled(false);
            user.sendMessage(ToggleDisplayCommands.feedbackMessage("/tabtps toggle tab", Messages.COMMAND_TOGGLE_TAB_DISABLED, NamedTextColor.RED));
        } else {
            user.tab().enabled(true);
            user.tab().startDisplay();
            user.sendMessage(ToggleDisplayCommands.feedbackMessage("/tabtps toggle tab", Messages.COMMAND_TOGGLE_TAB_ENABLED, NamedTextColor.GREEN));
        }
        user.markDirty();
    }

    private void toggleActionBar(@NonNull CommandContext<User<?>> context) {
        User<?> user = context.sender();
        if (user.actionBar().enabled()) {
            user.actionBar().stopDisplay();
            user.actionBar().enabled(false);
            user.sendMessage(ToggleDisplayCommands.feedbackMessage("/tabtps toggle actionbar", Messages.COMMAND_TOGGLE_ACTIONBAR_DISABLED, NamedTextColor.RED));
        } else {
            user.actionBar().enabled(true);
            user.actionBar().startDisplay();
            user.sendMessage(ToggleDisplayCommands.feedbackMessage("/tabtps toggle actionbar", Messages.COMMAND_TOGGLE_ACTIONBAR_ENABLED, NamedTextColor.GREEN));
        }
        user.markDirty();
    }

    private void toggleBossBar(@NonNull CommandContext<User<?>> context) {
        User<?> user = context.sender();
        if (user.bossBar().enabled()) {
            user.bossBar().stopDisplay();
            user.bossBar().enabled(false);
            user.sendMessage(ToggleDisplayCommands.feedbackMessage("/tabtps toggle bossbar", Messages.COMMAND_TOGGLE_BOSSBAR_DISABLED, NamedTextColor.RED));
        } else {
            user.bossBar().enabled(true);
            user.bossBar().startDisplay();
            user.sendMessage(ToggleDisplayCommands.feedbackMessage("/tabtps toggle bossbar", Messages.COMMAND_TOGGLE_BOSSBAR_ENABLED, NamedTextColor.GREEN));
        }
        user.markDirty();
    }

    private static @NonNull Component feedbackMessage(@NonNull String command, @NonNull TranslatableProvider translatable, @NonNull TextColor color) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Constants.PREFIX)).append((Component)Component.space())).append((Component)translatable.build(tr -> {
            tr.color(color);
            tr.decorate(TextDecoration.ITALIC);
            tr.hoverEvent((HoverEventSource)Messages.MISC_TEXT_CLICK_TO_TOGGLE.styled((TextColor)NamedTextColor.GREEN, new ComponentLike[0]));
            tr.clickEvent(ClickEvent.runCommand(command));
        }))).build();
    }
}

