/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;
import xyz.jpenilla.tabtps.common.command.exception.CommandCompletedException;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;
import xyz.jpenilla.tabtps.common.util.PingUtil;
import xyz.jpenilla.tabtps.common.util.TranslatableProvider;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ComponentLike;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.feature.pagination.Pagination;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.NamedTextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.Style;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextDecoration;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.component.DefaultValue;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.description.Description;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.execution.CommandExecutionHandler;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.standard.IntegerParser;

public class PingCommand
extends TabTPSCommand {
    public PingCommand(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        super(tabTPS, commands);
    }

    @Override
    public void register() {
        this.commands.register(this.commandManager.commandBuilder("ping", new String[0]).permission("tabtps.ping").commandDescription(RichDescription.richDescription(Messages.COMMAND_PING_SELF_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::onPingSelf));
        this.commands.register(this.commandManager.commandBuilder("pingall", new String[0]).optional("page", IntegerParser.integerParser(1, 999), DefaultValue.constant(1), (Description)RichDescription.richDescription(Messages.COMMAND_PING_ARGUMENTS_PAGE)).permission("tabtps.ping.others").commandDescription(RichDescription.richDescription(Messages.COMMAND_PING_ALL_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::onPingAll));
    }

    protected <T> void registerPingTargetsCommand(@NonNull ParserDescriptor<Commander, T> targetsArgument, @NonNull CommandExecutionHandler<Commander> handler) {
        this.commands.register(this.commandManager.commandBuilder("ping", new String[0]).required("target", targetsArgument, (Description)RichDescription.richDescription(Messages.COMMAND_PING_TARGET_ARGUMENTS_TARGET)).optional("page", IntegerParser.integerParser(1, 999), DefaultValue.constant(1), (Description)RichDescription.richDescription(Messages.COMMAND_PING_ARGUMENTS_PAGE)).permission("tabtps.ping.others").commandDescription(RichDescription.richDescription(Messages.COMMAND_PING_TARGET_DESCRIPTION.plain(new ComponentLike[0]))).handler(handler));
    }

    private void onPingAll(@NonNull CommandContext<Commander> context) {
        Commander sender = context.sender();
        int page = (Integer)context.get("page");
        this.pingMultiple(sender, Collections.unmodifiableCollection(this.tabTPS.platform().userService().onlineUsers()), page, "pingall");
    }

    private void onPingSelf(@NonNull CommandContext<Commander> context) {
        Commander sender = context.sender();
        if (!(sender instanceof User)) {
            throw CommandCompletedException.withMessage(Components.ofChildren(Constants.PREFIX, Component.space(), Messages.COMMAND_PING_TEXT_CONSOLE_MUST_PROVIDE_PLAYER.styled((TextColor)NamedTextColor.RED, new ComponentLike[0])));
        }
        User player = (User)sender;
        player.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Constants.PREFIX)).append((Component)Component.space())).append((Component)Messages.COMMAND_PING_SELF_TEXT_YOUR_PING.styled((TextColor)NamedTextColor.GRAY, Components.ofChildren(PingUtil.coloredPing(player, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled(Theme.DEFAULT.colorScheme().textSecondary(), new ComponentLike[0])))));
    }

    protected final void pingTargets(@NonNull Commander commander, @NonNull List<User<?>> targets, @NonNull String inputString, int page) {
        if (targets.isEmpty()) {
            throw CommandCompletedException.withMessage(Components.ofChildren(Constants.PREFIX, Component.space(), Messages.MISC_COMMAND_TEXT_NO_PLAYERS_FOUND.styled((TextColor)NamedTextColor.RED, Component.text(inputString))));
        }
        if (targets.size() > 1) {
            this.pingMultiple(commander, targets, page, String.format("ping %s", inputString));
            return;
        }
        User<?> targetPlayer = targets.get(0);
        commander.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Constants.PREFIX)).append((Component)Component.space())).append((Component)Messages.COMMAND_PING_TARGET_TEXT_TARGETS_PING.styled((TextColor)NamedTextColor.GRAY, targetPlayer.displayName(), Components.ofChildren(PingUtil.coloredPing(targetPlayer, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled(Theme.DEFAULT.colorScheme().textSecondary(), new ComponentLike[0])))));
    }

    private void pingMultiple(@NonNull Commander sender, @NonNull Collection<User<?>> targets, int page, @NonNull String commandPrefix) {
        ArrayList content = new ArrayList();
        ArrayList pings = new ArrayList();
        targets.stream().sorted(Comparator.comparing(User::ping)).forEach(player -> {
            content.add(Components.ofChildren(Component.space(), Component.text("-", (TextColor)NamedTextColor.GRAY), Component.space(), player.displayName(), Component.text(":", (TextColor)NamedTextColor.GRAY), Component.space(), PingUtil.coloredPing(player, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0])));
            pings.add(player.ping());
        });
        int avgPing = (int)Math.round(pings.stream().mapToInt(i -> i).average().orElse(0.0));
        TranslatableProvider playerAmountTranslatable = targets.size() == 1 ? Messages.COMMAND_PING_TEXT_AMOUNT_PLAYERS_SINGULAR : Messages.COMMAND_PING_TEXT_AMOUNT_PLAYERS;
        TextComponent playerAmount = Components.ofChildren(Component.text('(', (TextColor)NamedTextColor.WHITE), playerAmountTranslatable.styled((TextColor)NamedTextColor.GRAY, Component.text(this.tabTPS.platform().userService().onlinePlayers(), (TextColor)NamedTextColor.GREEN)), Component.text(')', (TextColor)NamedTextColor.WHITE));
        TextComponent summary = Components.ofChildren(Messages.COMMAND_PING_TEXT_AVERAGE_PING.styled((TextColor)NamedTextColor.WHITE, new ComponentLike[0]), Component.text(": ", (TextColor)NamedTextColor.GRAY), PingUtil.coloredPing(avgPing, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0]), Component.space(), playerAmount);
        ArrayList<Component> messages = new ArrayList<Component>();
        messages.add(Component.empty());
        messages.addAll(PingCommand.pagination(commandPrefix).render(content, page));
        messages.add(Component.empty());
        messages.add(summary);
        messages.forEach(sender::sendMessage);
    }

    private static @NonNull Pagination<Component> pagination(@NonNull String prefix) {
        return Pagination.builder().resultsPerPage(10).width(38).line(line -> line.character('-').style(Style.style(TextColor.color(4704511), TextDecoration.STRIKETHROUGH))).build(Components.ofChildren(Constants.PREFIX, Component.space(), Messages.COMMAND_PING_TEXT_PLAYER_PINGS), (value, index) -> Collections.singleton(value), page -> String.format("/%s %d", prefix, page));
    }
}

