/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import java.util.Map;
import java.util.stream.Collectors;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ComponentLike;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.component.DefaultValue;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.component.TypedCommandComponent;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.help.result.CommandEntry;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.AudienceProvider;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.MinecraftHelp;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.parser.standard.StringParser;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.suggestion.SuggestionProvider;

public final class HelpCommand
extends TabTPSCommand {
    public HelpCommand(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        super(tabTPS, commands);
    }

    @Override
    public void register() {
        TypedCommandComponent queryArgument = TypedCommandComponent.builder().name("query").parser(StringParser.greedyStringParser()).optional().defaultValue(DefaultValue.constant("")).suggestionProvider(SuggestionProvider.blockingStrings(this::helpQuerySuggestions)).description(RichDescription.richDescription(Messages.COMMAND_HELP_ARGUMENTS_QUERY)).build();
        this.commands.registerSubcommand(builder -> builder.literal("help", new String[0]).argument(queryArgument).commandDescription(RichDescription.richDescription(Messages.COMMAND_HELP_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::executeHelp));
    }

    private void executeHelp(@NonNull CommandContext<Commander> context) {
        this.help().queryCommands((String)context.get("query"), context.sender());
    }

    public @NonNull Iterable<String> helpQuerySuggestions(@NonNull CommandContext<Commander> context, @NonNull CommandInput input) {
        return this.commands.commandManager().createHelpHandler().queryRootIndex(context.sender()).entries().stream().map(CommandEntry::syntax).collect(Collectors.toList());
    }

    private @NonNull MinecraftHelp<Commander> help() {
        return MinecraftHelp.builder().commandManager(this.commandManager).audienceProvider(AudienceProvider.nativeAudience()).commandPrefix("/tabtps help").colors(this.tabTPS.configManager().pluginSettings().helpColors().toCloud()).messageProvider(HelpCommand::helpMessage).build();
    }

    private static @NonNull Component helpMessage(@NonNull Commander sender, @NonNull String key, @NonNull Map<String, String> args) {
        return Component.translatable(Messages.bundleName() + "/help." + key, args.values().stream().map(Component::text).collect(Collectors.toList()));
    }
}

