/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.exception.CommandCompletedException;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;
import xyz.jpenilla.tabtps.lib.io.leangen.geantyref.GenericTypeReflector;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.Component;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.ComponentLike;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TextComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.TranslatableComponent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.event.ClickEvent;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.event.HoverEventSource;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.NamedTextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextColor;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.text.format.TextDecoration;
import xyz.jpenilla.tabtps.lib.net.kyori.adventure.util.ComponentMessageThrowable;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.CommandManager;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.caption.CaptionVariable;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.ArgumentParseException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.CommandExecutionException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.InvalidCommandSenderException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.InvalidSyntaxException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.NoPermissionException;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.handling.ExceptionContext;
import xyz.jpenilla.tabtps.lib.org.incendo.cloud.exception.parsing.ParserException;

public final class ExceptionHandler {
    private final TabTPS tabTPS;

    ExceptionHandler(@NonNull TabTPS tabTPS) {
        this.tabTPS = tabTPS;
    }

    private static void decorateAndSend(@NonNull Commander commander, @NonNull ComponentLike componentLike) {
        commander.sendMessage(Components.ofChildren(Constants.PREFIX, Component.space(), componentLike));
    }

    public void apply(@NonNull CommandManager<Commander> manager) {
        manager.exceptionController().registerHandler(CommandExecutionException.class, this::commandExecution);
        manager.exceptionController().registerHandler(NoPermissionException.class, this::noPermission);
        manager.exceptionController().registerHandler(ArgumentParseException.class, this::argumentParsing);
        manager.exceptionController().registerHandler(InvalidCommandSenderException.class, this::invalidSender);
        manager.exceptionController().registerHandler(InvalidSyntaxException.class, this::invalidSyntax);
    }

    private void commandExecution(@NonNull ExceptionContext<Commander, CommandExecutionException> ctx) {
        Throwable cause = ctx.exception().getCause();
        if (cause instanceof CommandCompletedException) {
            Component message = ((CommandCompletedException)cause).componentMessage();
            if (message != null) {
                ctx.context().sender().sendMessage(message);
            }
            return;
        }
        this.tabTPS.platform().logger().warn("An unexpected error occurred during command execution", cause);
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        TextComponent.Builder hoverText = Component.text();
        Component throwableMessage = ComponentMessageThrowable.getOrConvertMessage(this.tabTPS.platform().asComponentMessageThrowable(cause));
        if (throwableMessage != null) {
            ((TextComponent.Builder)((TextComponent.Builder)hoverText.append(throwableMessage)).append((Component)Component.newline())).append((Component)Component.newline());
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hoverText.append((Component)Component.text(stackTrace))).append((Component)Component.newline())).append((Component)Component.text("    "))).append((Component)Messages.MISC_TEXT_CLICK_TO_COPY.styled((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC, new ComponentLike[0]));
        TextComponent.Builder message = Component.text();
        message.append((Component)Messages.COMMAND_EXCEPTION_COMMAND_EXECUTION.styled((TextColor)NamedTextColor.RED, new ComponentLike[0]));
        if (ctx.context().sender().hasPermission("tabtps.command.hover_stacktrace")) {
            message.hoverEvent((HoverEventSource)hoverText.build());
            message.clickEvent(ClickEvent.copyToClipboard(stackTrace));
        }
        ExceptionHandler.decorateAndSend(ctx.context().sender(), message);
    }

    private void noPermission(@NonNull ExceptionContext<Commander, NoPermissionException> ctx) {
        ExceptionHandler.decorateAndSend(ctx.context().sender(), Messages.COMMAND_EXCEPTION_NO_PERMISSION.styled((TextColor)NamedTextColor.RED, new ComponentLike[0]));
    }

    private void argumentParsing(@NonNull ExceptionContext<Commander, ArgumentParseException> ctx) {
        Component message;
        Throwable cause = ctx.exception().getCause();
        if (cause instanceof ParserException) {
            ParserException ex = (ParserException)cause;
            message = Component.translatable(Messages.bundleName() + "/command.caption." + ex.errorCaption().key(), (TextColor)NamedTextColor.GRAY, Arrays.stream(ex.captionVariables()).map(CaptionVariable::value).map(Component::text).collect(Collectors.toList()));
        } else {
            message = Objects.requireNonNull(ComponentMessageThrowable.getOrConvertMessage(this.tabTPS.platform().asComponentMessageThrowable(cause))).color(NamedTextColor.GRAY);
        }
        ExceptionHandler.decorateAndSend(ctx.context().sender(), Messages.COMMAND_EXCEPTION_INVALID_ARGUMENT.styled((TextColor)NamedTextColor.RED, message));
    }

    private void invalidSender(@NonNull ExceptionContext<Commander, InvalidCommandSenderException> ctx) {
        if (ctx.exception().requiredSenderTypes().size() > 1) {
            throw new IllegalStateException();
        }
        TranslatableComponent message = Messages.COMMAND_EXCEPTION_INVALID_SENDER_TYPE.styled((TextColor)NamedTextColor.RED, Component.text(GenericTypeReflector.erase(ctx.exception().requiredSenderTypes().iterator().next()).getSimpleName()));
        ExceptionHandler.decorateAndSend(ctx.context().sender(), message);
    }

    private void invalidSyntax(@NonNull ExceptionContext<Commander, InvalidSyntaxException> ctx) {
        TranslatableComponent message = Messages.COMMAND_EXCEPTION_INVALID_SYNTAX.styled((TextColor)NamedTextColor.RED, Components.highlight(Component.text(String.format("/%s", ctx.exception().correctSyntax()), (TextColor)NamedTextColor.GRAY), NamedTextColor.WHITE));
        ExceptionHandler.decorateAndSend(ctx.context().sender(), message);
    }
}

