/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.PluginSettings;
import xyz.jpenilla.tabtps.common.display.DisplayHandler;
import xyz.jpenilla.tabtps.common.display.task.ActionBarDisplayTask;
import xyz.jpenilla.tabtps.common.display.task.BossBarDisplayTask;
import xyz.jpenilla.tabtps.common.display.task.TabDisplayTask;
import xyz.jpenilla.tabtps.lib.org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.lib.org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public abstract class AbstractUser<P>
implements User<P> {
    private final P base;
    private final UUID uuid;
    private final User.State state;

    protected AbstractUser(TabTPS tabTPS, P base, UUID uuid) {
        this.base = base;
        this.uuid = uuid;
        this.state = new StateImpl(tabTPS, this);
    }

    @Override
    public final UUID uuid() {
        return this.uuid;
    }

    @Override
    public final P base() {
        return this.base;
    }

    @Override
    public User.State state() {
        return this.state;
    }

    public static final class StateImpl
    implements User.State {
        private final DisplayHandler<TabDisplayTask> tabDisplayHandler;
        private final DisplayHandler<ActionBarDisplayTask> actionBarDisplayHandler;
        private final DisplayHandler<BossBarDisplayTask> bossBarDisplayHandler;
        private transient boolean dirty = false;

        private StateImpl(TabTPS tabTPS, User<?> user) {
            PluginSettings.UpdateRates rates = tabTPS.configManager().pluginSettings().updateRates();
            this.tabDisplayHandler = new DisplayHandler<TabDisplayTask>(tabTPS, user, rates.tab(), config -> new TabDisplayTask(tabTPS, user, config.tabSettings()));
            this.actionBarDisplayHandler = new DisplayHandler<ActionBarDisplayTask>(tabTPS, user, rates.actionBar(), config -> new ActionBarDisplayTask(tabTPS, user, config.actionBarSettings()));
            this.bossBarDisplayHandler = new DisplayHandler<BossBarDisplayTask>(tabTPS, user, rates.bossBar(), config -> new BossBarDisplayTask(tabTPS, user, config.bossBarSettings()));
        }

        @Override
        public void populate(User.State from) {
            this.bossBarDisplayHandler.enabled(from.bossBar().enabled());
            this.actionBarDisplayHandler.enabled(from.actionBar().enabled());
            this.tabDisplayHandler.enabled(from.tab().enabled());
            if (from.shouldSave()) {
                this.markDirty();
            }
        }

        @Override
        public DisplayHandler<TabDisplayTask> tab() {
            return this.tabDisplayHandler;
        }

        @Override
        public DisplayHandler<ActionBarDisplayTask> actionBar() {
            return this.actionBarDisplayHandler;
        }

        @Override
        public DisplayHandler<BossBarDisplayTask> bossBar() {
            return this.bossBarDisplayHandler;
        }

        @Override
        public List<DisplayHandler<?>> displays() {
            return Collections.unmodifiableList(Arrays.asList(this.tab(), this.actionBar(), this.bossBar()));
        }

        @Override
        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean shouldSave() {
            return this.dirty;
        }
    }
}

