/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.ChessCraft;

@DefaultQualifier(value=NonNull.class)
public final class Util {
    private Util() {
    }

    public static void scheduleOrRun(JavaPlugin plugin, Runnable runnable) {
        if (plugin.getServer().isStopping()) {
            ((ChessCraft)plugin).shutdownTasks().add(runnable);
        } else if (plugin.getServer().isPrimaryThread()) {
            runnable.run();
        } else {
            plugin.getServer().getScheduler().runTask((Plugin)plugin, runnable);
        }
    }

    public static void schedule(JavaPlugin plugin, Runnable runnable) {
        if (plugin.getServer().isStopping()) {
            ((ChessCraft)plugin).shutdownTasks().add(runnable);
        } else {
            plugin.getServer().getScheduler().runTask((Plugin)plugin, runnable);
        }
    }

    public static <E> List<E> peekLast(List<E> list, int x) {
        if ((list = List.copyOf(list)).size() == x) {
            return list;
        }
        if (list.size() > x) {
            return list.subList(list.size() - x, list.size());
        }
        return list;
    }

    public static @Nullable String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }
}

