/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.text.DecimalFormat;
import java.time.Duration;

public final class TimeUtil {
    private static final DecimalFormat DF = new DecimalFormat(".00");

    private TimeUtil() {
    }

    public static String formatDurationClock(Duration d) {
        return TimeUtil.formatDurationClock(d, ClockFormatMode.DEFAULT);
    }

    public static String formatDurationClock(Duration d, ClockFormatMode mode) {
        long hours = d.toHours();
        long minutes = d.toMinutesPart();
        long seconds = d.toSecondsPart();
        if (hours == 0L && seconds == 0L && mode == ClockFormatMode.TIME) {
            return String.format("%s", minutes);
        }
        if (hours == 0L && minutes == 0L) {
            switch (mode.ordinal()) {
                case 0: {
                    if (seconds > 30L) break;
                    double partialSeconds = (double)d.toMillisPart() / 1000.0;
                    return String.format("0:%02d%s", seconds, DF.format(partialSeconds));
                }
                case 1: {
                    return String.format("0:%d", seconds);
                }
                case 2: {
                    return String.format("%d", seconds);
                }
            }
        } else if (hours > 0L) {
            return String.format("%d:%d:%02d", hours, minutes, seconds);
        }
        return String.format("%d:%02d", minutes, seconds);
    }

    public static enum ClockFormatMode {
        DEFAULT,
        TIME,
        INCREMENT;

    }
}

