/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.dependency.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import xyz.jpenilla.chesscraft.dependency.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import xyz.jpenilla.chesscraft.dependency.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.enums.Variant;
import xyz.jpenilla.chesscraft.util.ProcessorUtil;

public final class StockfishProvider {
    private static final String STOCKFISH_REPO = "official-stockfish/Stockfish";
    private static final String GITHUB_RELEASE_LIST = "https://api.github.com/repos/official-stockfish/Stockfish/releases";
    private static final String ARCHIVE_BASE_URL = "https://files.stockfishchess.org/archive/";
    private static final String LEGACY_BASE_URL = "https://files.stockfishchess.org/files/";
    private static final String LEGACY_BASE_URL_INTERNET_ARCHIVE = "https://web.archive.org/web/20230311015912id_/https://stockfishchess.org/files/";
    private final Path dir;
    private final ChessCraft plugin;

    public StockfishProvider(ChessCraft plugin, Path enginesDir) {
        this.plugin = plugin;
        this.dir = enginesDir;
        for (Path path : List.of(this.dir.resolve("custom"), this.dir.resolve("managed"))) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Path engine(String configValue) {
        Path file;
        if (!configValue.contains(":")) {
            Path customPath;
            Path path = customPath = configValue.startsWith("/") ? Path.of(configValue, new String[0]) : this.dir.resolve("custom").resolve(configValue);
            if (!customPath.toFile().canExecute() && !customPath.toFile().setExecutable(true, true)) {
                this.plugin.getLogger().warning("Custom engine '{}' was not executable and ChessCraft failed to set it to executable, this may cause issues.");
            }
            return customPath;
        }
        String[] split = configValue.split(":");
        String version = split[0];
        String[] ver = version.split("\\.");
        int major = Integer.parseInt(ver[0]);
        Variant variant = split[1].equalsIgnoreCase("auto") ? ProcessorUtil.bestVariant(this.plugin.getSLF4JLogger(), major < 16) : Variant.valueOf(split[1].toUpperCase(Locale.ENGLISH));
        Object path = "managed/" + variant.fileName(StockfishProvider.windows(), version, false);
        if (major > 15 && StockfishProvider.macOS()) {
            path = ((String)path).replace("linux", "mac").replace("popcnt", "modern");
        }
        if (Files.isRegularFile(file = this.dir.resolve((String)path), new LinkOption[0])) {
            return file;
        }
        List<String> urls = StockfishProvider.urls(version, variant, major > 15);
        try {
            for (String url : urls) {
                if (this.tryDownload(version, variant, file, url)) break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.plugin.getLogger().info("Done!");
        return file;
    }

    private static List<String> urls(String version, Variant variant, boolean sf16Plus) {
        JsonArray result;
        String downloadZipName = variant.fileName(StockfishProvider.windows(), version, true);
        if (!sf16Plus) {
            return List.of("https://files.stockfishchess.org/archive/Stockfish " + version + "/" + downloadZipName, LEGACY_BASE_URL + downloadZipName, LEGACY_BASE_URL_INTERNET_ARCHIVE + downloadZipName);
        }
        try {
            result = (JsonArray)new Gson().fromJson((Reader)new InputStreamReader(URI.create(GITHUB_RELEASE_LIST).toURL().openStream(), Charsets.UTF_8), JsonArray.class);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Failed to fetch Stockfish release list from GitHub.", exception);
        }
        JsonObject found = null;
        for (Object element : result) {
            JsonObject object;
            String tagName;
            if (!(element instanceof JsonObject) || (tagName = (object = (JsonObject)element).get("tag_name").getAsString()).length() <= 3 || !tagName.substring(3).equals(version)) continue;
            found = object;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("Could not find Stockfish release sf_" + version + " on GitHub.");
        }
        JsonObject foundAsset = null;
        for (JsonElement assetElement : found.get("assets").getAsJsonArray()) {
            JsonObject assetObject;
            String assetName;
            if (!(assetElement instanceof JsonObject) || !StockfishProvider.checkVariant(variant, assetName = (assetObject = (JsonObject)assetElement).get("name").getAsString()) || !StockfishProvider.checkOs(assetName)) continue;
            foundAsset = assetObject;
            break;
        }
        if (foundAsset == null) {
            throw new IllegalStateException("Could not find download Stockfish " + version + " " + String.valueOf((Object)variant) + " for " + System.getProperty("os.name"));
        }
        String url = foundAsset.get("browser_download_url").getAsString();
        return List.of(url);
    }

    private static boolean checkVariant(Variant variant, String name) {
        return switch (variant) {
            default -> throw new MatchException(null, null);
            case Variant.DEFAULT -> {
                if (!(name.contains("avx2") || name.contains("bmi2") || name.contains("modern"))) {
                    yield true;
                }
                yield false;
            }
            case Variant.AVX2 -> name.contains("avx2");
            case Variant.BMI2 -> name.contains("bmi2");
            case Variant.POPCNT -> name.contains("modern");
        };
    }

    private static boolean checkOs(String name) {
        if (StockfishProvider.windows()) {
            return name.contains("win");
        }
        if (StockfishProvider.macOS()) {
            return name.contains("mac");
        }
        return name.contains("ubuntu") || name.contains("linux");
    }

    private boolean tryDownload(String version, Variant variant, Path file, String urlString) throws IOException {
        URL url = URI.create(urlString).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        if (conn.getResponseCode() != 200) {
            return false;
        }
        String variantString = StockfishProvider.macOS() && variant == Variant.POPCNT ? "MODERN" : variant.toString();
        this.plugin.getLogger().info("Downloading Stockfish " + version + " (" + variantString + ") from '" + String.valueOf(url) + "'...");
        Path temp = Files.createTempFile("stockfish-" + version + "-" + String.valueOf((Object)variant) + "-download", null, new FileAttribute[0]);
        try (InputStream stream = url.openStream();
             FileOutputStream out = new FileOutputStream(temp.toFile());){
            ReadableByteChannel channel = Channels.newChannel(stream);
            out.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
        }
        boolean found = urlString.endsWith(".zip") ? this.extractFromZip(temp, file) : this.extractFromTar(temp, file, urlString);
        if (!found) {
            throw new IllegalStateException("Could not find stockfish executable in downloaded archive");
        }
        if (!file.toFile().setExecutable(true, true)) {
            this.plugin.getLogger().warning("Failed to set extracted file " + String.valueOf(file) + " executable, this may cause issues");
        }
        Files.delete(temp);
        return true;
    }

    private boolean extractFromZip(Path archive, Path dest) throws IOException {
        try (FileSystem fs = FileSystems.newFileSystem(archive, new HashMap());
             Stream<Path> s = Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0]);){
            Iterator<Path> iterator = s.toList().iterator();
            while (true) {
                if (iterator.hasNext()) {
                    Path path = iterator.next();
                    if (!Files.isRegularFile(path, new LinkOption[0]) || !path.getFileName().toString().startsWith("stockfish-") && !path.getFileName().toString().startsWith("stockfish_")) continue;
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    Files.copy(path, dest, new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        return false;
    }

    private boolean extractFromTar(Path archive, Path dest, String urlString) throws IOException {
        boolean gzip = urlString.endsWith(".gz");
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(archive, new OpenOption[0]));
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)(gzip ? new GzipCompressorInputStream((InputStream)inputStream) : inputStream));){
            while (true) {
                TarArchiveEntry entry;
                if ((entry = tar.getNextEntry()) != null) {
                    String fileName = entry.getName().substring(entry.getName().lastIndexOf("/") + 1);
                    if (entry.isDirectory() || !fileName.startsWith("stockfish-") && !fileName.startsWith("stockfish_")) continue;
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    Files.copy((InputStream)tar, dest, new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                    continue;
                }
                break;
            }
        }
        return false;
    }

    private static boolean windows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static boolean macOS() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }
}

