/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;

public final class SteppedAnimation {
    private final int startDelay;
    private final HashMap<Integer, List<Runnable>> steps;

    private SteppedAnimation(int startDelay, Map<Integer, List<Runnable>> steps) {
        this.startDelay = startDelay;
        this.steps = new HashMap<Integer, List<Runnable>>(steps);
    }

    public boolean tick(int tick) {
        @Nullable List<Runnable> remove = this.steps.remove(tick);
        if (remove != null) {
            for (Runnable runnable : remove) {
                runnable.run();
            }
        }
        return !this.steps.isEmpty();
    }

    public static final class Builder {
        private final Map<Integer, List<Runnable>> steps = new HashMap<Integer, List<Runnable>>();
        private int startDelay = 0;

        public DelayScope step(int delay, Runnable task) {
            this.steps.computeIfAbsent(delay, $ -> new ArrayList()).add(task);
            return new DelayScope(delay);
        }

        public @This Builder startDelay(int startDelay) {
            this.startDelay = startDelay;
            return this;
        }

        public SteppedAnimation build() {
            return new SteppedAnimation(this.startDelay, this.steps);
        }

        public final class DelayScope {
            private final int delay;

            private DelayScope(int delay) {
                this.delay = delay;
            }

            public DelayScope then(int delay, Runnable task) {
                return Builder.this.step(this.delay + delay, task);
            }

            public Builder exitScope() {
                return Builder.this;
            }

            public SteppedAnimation build() {
                return Builder.this.build();
            }
        }
    }

    public static final class SequentialExecutor {
        private final Deque<Supplier<SteppedAnimation>> animations = new ConcurrentLinkedDeque<Supplier<SteppedAnimation>>();
        private final BukkitTask task;
        private int tick = 0;
        private volatile @Nullable SteppedAnimation current;

        public SequentialExecutor(JavaPlugin plugin) {
            this.task = plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this::tick, 0L, 1L);
        }

        private void tick() {
            SteppedAnimation current;
            Supplier<SteppedAnimation> anim;
            if (this.current == null && (anim = this.animations.pollFirst()) != null) {
                this.current = anim.get();
                this.tick = 0;
            }
            if ((current = this.current) != null) {
                if (this.tick < current.startDelay || current.tick(this.tick - current.startDelay)) {
                    ++this.tick;
                } else {
                    this.current = null;
                }
            }
        }

        public void schedule(Supplier<SteppedAnimation> animationFactory) {
            this.animations.addLast(animationFactory);
        }

        public void clearCurrent() {
            this.animations.clear();
            this.current = null;
        }

        public void cancel() {
            this.task.cancel();
            this.clearCurrent();
        }
    }
}

