/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.util.Locale;
import org.bytedeco.cpu_features.X86Features;
import org.bytedeco.cpu_features.global.cpu_features;
import org.slf4j.Logger;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.enums.Variant;

public final class ProcessorUtil {
    private ProcessorUtil() {
    }

    public static Variant bestVariant(Logger logger, boolean bmi2Available) {
        CpuArchitecture arch = CpuArchitecture.get();
        switch (arch.ordinal()) {
            case 1: {
                return Variant.POPCNT;
            }
            case 3: {
                X86Features features = cpu_features.GetX86Info().features();
                if (bmi2Available && features.bmi2() != 0) {
                    return Variant.BMI2;
                }
                if (features.avx2() != 0) {
                    return Variant.AVX2;
                }
                if (features.popcnt() == 0) break;
                return Variant.POPCNT;
            }
            default: {
                logger.info("Unable to determine best Stockfish variant for architecture '{}', falling back to default variant.", (Object)arch);
            }
        }
        return Variant.DEFAULT;
    }

    private static enum CpuArchitecture {
        UNKNOWN,
        AARCH64,
        ARM,
        X86;


        public static CpuArchitecture get() {
            String arch;
            return switch (arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9]+", "")) {
                case "aarch64" -> AARCH64;
                case "arm", "arm32" -> ARM;
                case "x8664", "amd64", "ia32e", "em64t", "x64" -> X86;
                default -> UNKNOWN;
            };
        }
    }
}

