/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.util.function.IntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.config.Messages;
import xyz.jpenilla.chesscraft.util.Pagination;

@DefaultQualifier(value=NonNull.class)
public final class PaginationHelper {
    private final ChessCraft plugin;

    public PaginationHelper(ChessCraft plugin) {
        this.plugin = plugin;
    }

    private Messages messages() {
        return this.plugin.config().messages();
    }

    public Pagination.Builder.Renderer footerRenderer(IntFunction<String> commandFunction) {
        return (currentPage, pages) -> {
            if (pages == 1) {
                return Component.empty();
            }
            TextComponent.Builder buttons = Component.text();
            if (currentPage > 1) {
                buttons.append(this.previousPageButton(currentPage, commandFunction));
            }
            if (currentPage > 1 && currentPage < pages) {
                buttons.append((Component)Component.space());
            }
            if (currentPage < pages) {
                buttons.append(this.nextPageButton(currentPage, commandFunction));
            }
            return this.messages().paginationFooter(currentPage, pages, (ComponentLike)buttons);
        };
    }

    public Pagination.Builder.Renderer pageOutOfRange() {
        return (page, pages) -> this.messages().pageOutOfRange(page, pages);
    }

    public Component wrapElement(ComponentLike element) {
        return Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)" - ", (TextColor)NamedTextColor.GRAY), element});
    }

    private Component previousPageButton(int currentPage, IntFunction<String> commandFunction) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u2190").clickEvent(ClickEvent.runCommand((String)commandFunction.apply(currentPage - 1)))).hoverEvent((HoverEventSource)this.messages().clickForPreviousPage())).build();
    }

    private Component nextPageButton(int currentPage, IntFunction<String> commandFunction) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u2192").clickEvent(ClickEvent.runCommand((String)commandFunction.apply(currentPage + 1)))).hoverEvent((HoverEventSource)this.messages().clickForNextPage())).build();
    }
}

