/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public interface Pagination<T> {
    public ComponentLike header(int var1, int var2);

    public ComponentLike footer(int var1, int var2);

    public ComponentLike pageOutOfRange(int var1, int var2);

    public ComponentLike item(T var1, boolean var2);

    default public List<Component> render(Collection<T> content, int page, int itemsPerPage) {
        Component footer;
        if (content.isEmpty()) {
            throw new IllegalArgumentException("Cannot paginate an empty collection.");
        }
        int pages = (int)Math.ceil((double)content.size() / ((double)itemsPerPage * 1.0));
        if (page < 1 || page > pages) {
            return Collections.singletonList(this.pageOutOfRange(page, pages).asComponent());
        }
        ArrayList<Component> renderedContent = new ArrayList<Component>();
        Component header = this.header(page, pages).asComponent();
        if (header != Component.empty()) {
            renderedContent.add(header);
        }
        int start = itemsPerPage * (page - 1);
        int maxIndex = start + itemsPerPage;
        if (content instanceof RandomAccess && content instanceof List) {
            List contentList = (List)content;
            for (int i = start; i < maxIndex && i <= content.size() - 1; ++i) {
                renderedContent.add(this.item(contentList.get(i), i == maxIndex - 1).asComponent());
            }
        } else {
            int i;
            Iterator<T> iterator = content.iterator();
            for (i = 0; i < start && iterator.hasNext(); ++i) {
                iterator.next();
            }
            for (i = start; i < maxIndex && iterator.hasNext(); ++i) {
                renderedContent.add(this.item(iterator.next(), i == maxIndex - 1).asComponent());
            }
        }
        if ((footer = this.footer(page, pages).asComponent()) != Component.empty()) {
            renderedContent.add(footer);
        }
        return Collections.unmodifiableList(renderedContent);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private Renderer headerRenderer = ($, $$) -> Component.empty();
        private Renderer footerRenderer = ($, $$) -> Component.empty();
        private @MonotonicNonNull Renderer pageOutOfRangeRenderer = null;
        private @MonotonicNonNull ItemRenderer<T> itemRenderer = null;

        private Builder() {
        }

        public Builder<T> header(Renderer headerRenderer) {
            this.headerRenderer = headerRenderer;
            return this;
        }

        public Builder<T> footer(Renderer footerRenderer) {
            this.footerRenderer = footerRenderer;
            return this;
        }

        public Builder<T> pageOutOfRange(Renderer pageOutOfRangeRenderer) {
            this.pageOutOfRangeRenderer = pageOutOfRangeRenderer;
            return this;
        }

        public Builder<T> item(ItemRenderer<T> itemRenderer) {
            this.itemRenderer = itemRenderer;
            return this;
        }

        public Pagination<T> build() {
            return new DelegatingPaginationImpl<T>(Objects.requireNonNull(this.headerRenderer, "Must provide a header renderer!"), Objects.requireNonNull(this.footerRenderer, "Must provide a footer renderer!"), Objects.requireNonNull(this.pageOutOfRangeRenderer, "Must provide a page out of range renderer!"), Objects.requireNonNull(this.itemRenderer, "Must provide an item renderer!"));
        }

        @FunctionalInterface
        public static interface Renderer {
            public ComponentLike apply(int var1, int var2);
        }

        @FunctionalInterface
        public static interface ItemRenderer<T> {
            public ComponentLike render(T var1, boolean var2);
        }

        private record DelegatingPaginationImpl<T>(Renderer headerRenderer, Renderer footerRenderer, Renderer pageOutOfRangeRenderer, ItemRenderer<T> itemRenderer) implements Pagination<T>
        {
            @Override
            public ComponentLike header(int page, int pages) {
                return this.headerRenderer.apply(page, pages);
            }

            @Override
            public ComponentLike footer(int page, int pages) {
                return this.footerRenderer.apply(page, pages);
            }

            @Override
            public ComponentLike pageOutOfRange(int page, int pages) {
                return this.pageOutOfRangeRenderer.apply(page, pages);
            }

            @Override
            public ComponentLike item(T item, boolean lastOfPage) {
                return this.itemRenderer.render(item, lastOfPage);
            }
        }
    }
}

