/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import java.time.LocalDateTime;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.returnsreceiver.qual.This;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.data.BoardPosition;
import xyz.jpenilla.chesscraft.data.piece.Piece;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.db.Database;

public final class MatchExporter {
    private final GameState state;
    private final StringBuilder out;

    private MatchExporter(GameState state) {
        this.state = state;
        this.out = new StringBuilder();
    }

    public static CompletableFuture<String> writePgn(GameState state, Database db) {
        return new MatchExporter(state).writePgn(db);
    }

    private CompletableFuture<String> writePgn(Database db) {
        CompletableFuture<? extends ChessPlayer> whiteFuture = this.state.whiteOffline(db);
        CompletableFuture<? extends ChessPlayer> blackFuture = this.state.blackOffline(db);
        return CompletableFuture.allOf(whiteFuture, blackFuture).thenApply($ -> {
            String resultString;
            LocalDateTime lastUpdated = this.state.lastUpdated().toLocalDateTime();
            this.appendTag("Event", "ChessCraft Match").appendTag("Site", "Minecraft").appendTag("Date", String.format("%d.%02d.%d", lastUpdated.getYear(), lastUpdated.getMonthValue(), lastUpdated.getDayOfMonth())).appendTag("Round", "1").appendTag("White", PlainTextComponentSerializer.plainText().serialize(((ChessPlayer)whiteFuture.join()).name())).appendTag("Black", PlainTextComponentSerializer.plainText().serialize(((ChessPlayer)blackFuture.join()).name()));
            @Nullable GameState.Result result = this.state.result();
            if (result != null) {
                resultString = switch (result.type()) {
                    default -> throw new MatchException(null, null);
                    case GameState.ResultType.WIN -> {
                        if (result.color() == PieceColor.WHITE) {
                            yield "1-0";
                        }
                        yield "0-1";
                    }
                    case GameState.ResultType.STALEMATE, GameState.ResultType.REPETITION, GameState.ResultType.DRAW_BY_50 -> "1/2-1/2";
                    case GameState.ResultType.FORFEIT, GameState.ResultType.OUT_OF_TIME -> result.color() == PieceColor.WHITE ? "0-1" : "1-0";
                };
            } else {
                resultString = null;
                this.appendTag("Result", "*");
            }
            if (resultString != null) {
                this.appendTag("Result", resultString).appendTag("Termination", result.toString());
            }
            if (this.state.whiteCpu()) {
                this.appendTag("WhiteElo", String.valueOf(this.state.whiteElo()));
            }
            if (this.state.blackCpu()) {
                this.appendTag("BlackElo", String.valueOf(this.state.blackElo()));
            }
            this.appendTag("Time", String.format("%02d:%02d:%02d", lastUpdated.getHour(), lastUpdated.getMinute(), lastUpdated.getSecond()));
            this.out.append('\n');
            for (int i = 0; i < this.state.moves().size(); ++i) {
                ChessGame.Move move = this.state.moves().get(i);
                Piece movedPiece = move.boardAfter().piece(BoardPosition.fromString(move.notation().substring(2)));
                String prefix = movedPiece.type() == PieceType.PAWN ? "" : movedPiece.type().upper();
                this.out.append(i + 1).append(i % 2 == 0 ? ". " : "... ").append(prefix).append(move.notation().substring(0, 4));
                if (move.notation().length() == 5) {
                    this.out.append('=').append(String.valueOf(move.notation().charAt(4)).toUpperCase(Locale.ROOT));
                }
                this.out.append(' ');
            }
            if (resultString != null) {
                this.out.append(resultString);
            }
            return this.out.toString();
        });
    }

    private @This MatchExporter appendTag(String name, String value) {
        this.out.append("[").append(name).append(" \"").append(value).append("\"]").append('\n');
        return this;
    }
}

