/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.util;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class Elo {
    public static final int INITIAL_RATING = 1000;

    public static NewRatings computeNewRatings(@Nullable RatingData playerOne, @Nullable RatingData playerTwo, MatchOutcome result) {
        Match match = new Match(playerOne == null ? RatingData.newPlayer() : playerOne, playerTwo == null ? RatingData.newPlayer() : playerTwo, result);
        return match.computeNewRatings();
    }

    private record Match(RatingData playerOne, RatingData playerTwo, MatchOutcome result) {
        public NewRatings computeNewRatings() {
            return new NewRatings(this.playerOne.update(this.score(this.playerOne), this.playerTwo.rating()), this.playerTwo.update(this.score(this.playerTwo), this.playerOne.rating()));
        }

        private double score(RatingData player) {
            if (this.result == MatchOutcome.DRAW) {
                return 0.5;
            }
            if (this.result == MatchOutcome.PLAYER_ONE_WIN && player == this.playerOne || this.result == MatchOutcome.PLAYER_TWO_WIN && player == this.playerTwo) {
                return 1.0;
            }
            return 0.0;
        }
    }

    public record RatingData(int rating, int peakRating, int matches) {
        private RatingData update(double score, int opponentRating) {
            double ratingDelta = this.k() * (score - this.winOdds(opponentRating));
            int newRating = this.rating + (int)Math.round(ratingDelta);
            return new RatingData(newRating, Math.max(newRating, this.peakRating), this.matches + 1);
        }

        public double winOdds(int opponentRating) {
            int ratingDiff = Math.max(Math.min(opponentRating - this.rating(), 400), -400);
            return 1.0 / (1.0 + Math.pow(10.0, (double)ratingDiff / 400.0));
        }

        private double k() {
            if (this.matches < 30 && this.peakRating < 2400) {
                return 40.0;
            }
            if (this.peakRating < 2400) {
                return 20.0;
            }
            return 10.0;
        }

        public static RatingData newPlayer() {
            return new RatingData(1000, 1000, 0);
        }
    }

    public static enum MatchOutcome {
        PLAYER_ONE_WIN,
        PLAYER_TWO_WIN,
        DRAW;

    }

    public record NewRatings(RatingData playerOne, RatingData playerTwo) {
    }
}

