/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display.settings;

import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.util.Transformation;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.config.TransformationSettings;
import xyz.jpenilla.chesscraft.data.Rotation;
import xyz.jpenilla.chesscraft.data.Vec3d;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;
import xyz.jpenilla.chesscraft.display.PositionLabelsDisplay;
import xyz.jpenilla.chesscraft.display.settings.AbstractDisplaySettings;

@ConfigSerializable
public final class PositionLabelSettings
extends AbstractDisplaySettings<PositionLabelsDisplay> {
    private static final double SHIFT = 0.15625;
    private final transient TransformationSettings eastWestTransform;
    private final transient TransformationSettings northSouthTransform;
    public String labelFormat = "<white><label>";

    public PositionLabelSettings() {
        this.offset = new Vec3d(0.0, 0.01, 0.0);
        this.billboard = Display.Billboard.FIXED;
        this.textShadow = true;
        this.applyBackgroundColor = true;
        this.backgroundColor = Color.fromARGB((int)0, (int)0, (int)0, (int)0);
        this.eastWestTransform = new TransformationSettings(Vec3d.ZERO, new Rotation(0.0, -0.707, 0.0, 0.707), new Rotation(-0.707, 0.0, 0.0, 0.707));
        this.northSouthTransform = new TransformationSettings(Vec3d.ZERO, Rotation.DEFAULT, new Rotation(-0.707, 0.0, 0.0, 0.707));
    }

    @Override
    public BoardDisplaySettings.DisplayType type() {
        return BoardDisplaySettings.DisplayType.POSITION_LABELS;
    }

    @Override
    public PositionLabelsDisplay getOrCreateState(ChessCraft plugin, ChessBoard board) {
        return new PositionLabelsDisplay(plugin, board, this);
    }

    @Override
    public void remove(PositionLabelsDisplay state) {
        state.remove();
    }

    public Transformation eastWestTransformation(boolean flip, int boardScale) {
        TransformationSettings s = this.eastWestTransform.withTranslation(new Vec3d((flip ? 0.15625 : -0.15625) * this.scale + (double)(0.5f * (float)boardScale), 0.0, 0.5f * (float)boardScale));
        return this.transformation(s, flip);
    }

    public Transformation northSouthTransformation(boolean flip, int boardScale) {
        TransformationSettings s = this.northSouthTransform.withTranslation(new Vec3d(0.5f * (float)boardScale, 0.0, (flip ? -0.15625 : 0.15625) * this.scale + (double)(0.5f * (float)boardScale)));
        return this.transformation(s, flip);
    }
}

