/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display.settings;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.config.Messages;
import xyz.jpenilla.chesscraft.data.Vec3d;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.display.BoardBoundUpdatingText;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;
import xyz.jpenilla.chesscraft.display.settings.AbstractDisplaySettings;
import xyz.jpenilla.chesscraft.util.OptionTagResolver;
import xyz.jpenilla.chesscraft.util.Util;

@ConfigSerializable
public final class BoardStatusSettings
extends AbstractDisplaySettings.WithTransformation<BoardBoundUpdatingText> {
    private List<String> gameText = List.of("<b>Chess Board <board_name>", "<white>\u265a</white><white_displayname> <i><gray>vs</i> <black>\u265a</black><black_displayname>", "Current move: <current_move_color>\u265a</current_move_color><current_move_displayname>", "<time_control:'<white>\u265a</white><white_time> <gray>|</gray> <black>\u265a</black><black_time>':'<green>No time controls.'>");
    private List<String> noGameText = List.of("<b>Chess Board <board_name>", "<green>No active game.");
    private long updateRate = 10L;

    public BoardStatusSettings() {
        this.offset = new Vec3d(4.0, 4.5, -4.0);
    }

    @Override
    public BoardDisplaySettings.DisplayType type() {
        return BoardDisplaySettings.DisplayType.BOARD_STATUS;
    }

    @Override
    public BoardBoundUpdatingText getOrCreateState(ChessCraft plugin, ChessBoard board) {
        return new BoardBoundUpdatingText(plugin, board, this.offsetNudged(board).toLocation(board.world()), () -> this.text(board, board.hasGame()), this.updateRate, this);
    }

    private List<Component> text(ChessBoard board, boolean hasGame) {
        TagResolver.Builder tags = TagResolver.builder();
        if (hasGame) {
            ChessGame g = board.game();
            tags.resolver(Messages.playerTags(g.white(), "white", g.black(), "black", PieceColor.WHITE));
            tags.resolver(Messages.playerTags(g.player(g.nextMove()), "current_move", g.nextMove()));
            tags.resolver((TagResolver)new OptionTagResolver("time_control", g.time(g.white()) != null));
            if (g.time(g.white()) != null) {
                tags.resolvers(new TagResolver[]{Placeholder.unparsed((String)"white_time", (String)g.time(g.white()).timeLeftString()), Placeholder.unparsed((String)"black_time", (String)g.time(g.black()).timeLeftString())});
            }
        }
        tags.resolver((TagResolver)Placeholder.parsed((String)"board_name", (String)board.name()));
        TagResolver builtTags = tags.build();
        return (hasGame ? this.gameText : this.noGameText).stream().map(t -> MiniMessage.miniMessage().deserialize(t, builtTags)).toList();
    }

    @Override
    public void gameEnded(BoardBoundUpdatingText state) {
        state.stopUpdates();
        Util.schedule(state.plugin(), () -> state.text(this.text(state.board(), false)));
    }

    @Override
    public void remove(BoardBoundUpdatingText state) {
        state.remove();
    }
}

