/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display.settings;

import java.util.Set;
import org.bukkit.Color;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joml.Vector3f;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.config.TransformationSettings;
import xyz.jpenilla.chesscraft.data.Vec3d;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;

@ConfigSerializable
public abstract class AbstractDisplaySettings<S>
implements BoardDisplaySettings<S> {
    private boolean removeAfterGame = false;
    protected double scale = 2.0;
    protected TextDisplay.TextAlignment alignment = TextDisplay.TextAlignment.CENTER;
    protected Display.Billboard billboard = Display.Billboard.CENTER;
    protected Vec3d offset = Vec3d.ZERO;
    private Set<Axis> scaleOffsetWithBoard = Set.of(Axis.X, Axis.Z);
    private boolean visibleThroughWalls = false;
    protected boolean textShadow = false;
    protected boolean applyBackgroundColor = false;
    protected @Nullable Color backgroundColor = Color.FUCHSIA;

    @Override
    public boolean removeAfterGame() {
        return this.removeAfterGame;
    }

    public Vec3d offsetNudged(ChessBoard board) {
        return this.offset(board, board.loc().asVec3d()).add(0.0, 0.0, 1.0, board.scale());
    }

    public Vec3d offset(ChessBoard board, Vec3d pos) {
        int xScale = this.scaleOffsetWithBoard.contains((Object)Axis.X) ? board.scale() : 1;
        int yScale = this.scaleOffsetWithBoard.contains((Object)Axis.Y) ? board.scale() : 1;
        int zScale = this.scaleOffsetWithBoard.contains((Object)Axis.Z) ? board.scale() : 1;
        return pos.add(this.offset.x() * (double)xScale, this.offset.y() * (double)yScale, this.offset.z() * (double)zScale);
    }

    public void apply(TextDisplay display) {
        display.setAlignment(this.alignment);
        display.setBillboard(this.billboard);
        display.setSeeThrough(this.visibleThroughWalls);
        display.setShadowed(this.textShadow);
        if (this.applyBackgroundColor && this.backgroundColor != null) {
            display.setDefaultBackground(false);
            display.setBackgroundColor(this.backgroundColor);
        } else {
            display.setDefaultBackground(true);
            display.setBackgroundColor(null);
        }
    }

    public Transformation transformation(TransformationSettings settings, boolean flip) {
        return new Transformation(new Vector3f((float)settings.translation().x(), (float)settings.translation().y(), (float)settings.translation().z()), settings.leftRotation().asQuaternionf(), flip ? new Vector3f((float)this.scale * -1.0f, (float)this.scale, (float)this.scale * -1.0f) : new Vector3f((float)this.scale), settings.rightRotation().asQuaternionf());
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }

    @ConfigSerializable
    public static abstract class WithTransformation<S>
    extends AbstractDisplaySettings<S> {
        private TransformationSettings transformationDecomposed = new TransformationSettings();

        @Override
        public void apply(TextDisplay display) {
            super.apply(display);
            display.setTransformation(this.transformation(this.transformationDecomposed, false));
        }
    }
}

