/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import org.bukkit.Location;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.display.AbstractTextDisplayHolder;
import xyz.jpenilla.chesscraft.display.settings.AbstractDisplaySettings;
import xyz.jpenilla.chesscraft.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class MessageLogDisplayAudience
extends AbstractTextDisplayHolder
implements Audience {
    private final List<Component> messages = new CopyOnWriteArrayList<Component>();
    private final int lines;
    private final AbstractDisplaySettings<?> settings;

    public MessageLogDisplayAudience(JavaPlugin plugin, Location location, int lines, AbstractDisplaySettings<?> settings) {
        super(plugin, location);
        this.lines = lines;
        this.settings = settings;
    }

    public void sendMessage(Identity source, Component message, MessageType type) {
        this.messages.add(message);
        while (this.messages.size() > this.lines * 2) {
            this.messages.removeFirst();
        }
        this.updateIfEntityExists();
    }

    @Override
    protected void updateEntity(TextDisplay display) {
        MessageLogDisplayAudience.putMarker(display);
        this.settings.apply(display);
        display.text(Component.join((JoinConfiguration)JoinConfiguration.newlines(), Util.peekLast(this.messages, this.lines)));
    }

    @Override
    public void stopUpdates() {
    }

    @Override
    public void updateNow() {
    }
}

