/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.TypeSerializer;
import xyz.jpenilla.chesscraft.display.settings.BoardStatusSettings;
import xyz.jpenilla.chesscraft.display.settings.MessageLogSettings;
import xyz.jpenilla.chesscraft.display.settings.PositionLabelSettings;

public interface BoardDisplaySettings<S> {
    public DisplayType type();

    public boolean removeAfterGame();

    public S getOrCreateState(ChessCraft var1, ChessBoard var2);

    default public void gameEnded(S state) {
    }

    public void remove(S var1);

    public static final class Serializer
    implements TypeSerializer<BoardDisplaySettings<?>> {
        private static final String TYPE_FIELD_NAME = "type";

        @Override
        public BoardDisplaySettings<?> deserialize(Type type, ConfigurationNode node) throws SerializationException {
            DisplayType mode = node.node(TYPE_FIELD_NAME).get(DisplayType.class);
            if (mode == null) {
                throw new SerializationException("Missing mode, should be one of: " + Arrays.toString((Object[])DisplayType.values()));
            }
            return node.get(mode.type);
        }

        @Override
        public void serialize(Type type, @Nullable BoardDisplaySettings<?> obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                throw new SerializationException("null");
            }
            DisplayType mode = obj.type();
            node.node(TYPE_FIELD_NAME).set((Object)mode);
            node.set(mode.type, (Object)obj);
        }
    }

    public static enum DisplayType {
        MESSAGE_LOG(MessageLogSettings.class),
        BOARD_STATUS(BoardStatusSettings.class),
        POSITION_LABELS(PositionLabelSettings.class);

        private final Class<? extends BoardDisplaySettings<?>> type;

        private DisplayType(Class<? extends BoardDisplaySettings<?>> type) {
            this.type = type;
        }
    }
}

