/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import org.bukkit.Location;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.display.AbstractTextDisplayHolder;
import xyz.jpenilla.chesscraft.display.settings.AbstractDisplaySettings;

@DefaultQualifier(value=NonNull.class)
public final class BoardBoundUpdatingText
extends AbstractTextDisplayHolder {
    private final ChessBoard board;
    private final @Nullable BukkitTask update;
    private final @Nullable Runnable updateRunnable;
    private final AbstractDisplaySettings<?> settings;
    private final AtomicReference<Component> text = new AtomicReference();

    public BoardBoundUpdatingText(JavaPlugin plugin, ChessBoard board, Location pos, Supplier<List<Component>> textSupplier, long updateRate, AbstractDisplaySettings<?> settings) {
        super(plugin, pos);
        this.board = board;
        this.updateRunnable = () -> this.text((List)textSupplier.get());
        this.update = updateRate > 0L ? plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this.updateRunnable, 0L, updateRate) : null;
        this.settings = settings;
    }

    public ChessBoard board() {
        return this.board;
    }

    public void text(List<Component> lines) {
        Component old;
        Component n = Component.join((JoinConfiguration)JoinConfiguration.newlines(), lines);
        if (!n.equals((Object)(old = this.text.getAndSet(n)))) {
            this.updateIfEntityExists();
        }
    }

    @Override
    protected void updateEntity(TextDisplay display) {
        BoardBoundUpdatingText.putMarker(display);
        this.settings.apply(display);
        display.text(this.text.get());
    }

    @Override
    public void updateNow() {
        if (this.updateRunnable != null) {
            this.updateRunnable.run();
        }
    }

    @Override
    public void stopUpdates() {
        if (this.update != null) {
            this.update.cancel();
        }
    }
}

