/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.display;

import java.util.Collection;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.util.Util;

@DefaultQualifier(value=NonNull.class)
public abstract class AbstractTextDisplayHolder {
    private static final NamespacedKey MARKER = new NamespacedKey("chesscraft", "text_display");
    private final JavaPlugin plugin;
    private final Location pos;
    private volatile @Nullable UUID entityId;

    public AbstractTextDisplayHolder(JavaPlugin plugin, Location pos) {
        this.plugin = plugin;
        this.pos = pos;
    }

    public abstract void stopUpdates();

    public abstract void updateNow();

    protected abstract void updateEntity(TextDisplay var1);

    public JavaPlugin plugin() {
        return this.plugin;
    }

    public void remove() {
        this.stopUpdates();
        Util.scheduleOrRun(this.plugin, () -> {
            @Nullable TextDisplay entity = this.entity();
            if (entity != null) {
                entity.remove();
            }
            this.entityId = null;
        });
    }

    public void ensureSpawned() {
        if (this.entity() == null) {
            Collection nearby = this.pos.getNearbyEntities(0.1, 0.1, 0.1);
            @Nullable TextDisplay existing = nearby.stream().filter(TextDisplay.class::isInstance).map(TextDisplay.class::cast).filter(e -> e.getPersistentDataContainer().has(MARKER)).findFirst().orElse(null);
            if (existing != null) {
                existing.teleport(this.pos);
                this.entityId = existing.getUniqueId();
                this.updateEntity(existing);
            } else {
                TextDisplay spawned = (TextDisplay)this.pos.getWorld().spawn(this.pos, TextDisplay.class, this::updateEntity);
                this.entityId = spawned.getUniqueId();
            }
        }
    }

    protected @Nullable TextDisplay entity() {
        @Nullable UUID id = this.entityId;
        if (id == null) {
            return null;
        }
        return (TextDisplay)this.pos.getWorld().getEntity(id);
    }

    protected void updateIfEntityExists() {
        if (this.entityId != null) {
            Util.scheduleOrRun(this.plugin, () -> {
                @Nullable TextDisplay entity = this.entity();
                if (entity != null) {
                    this.updateEntity(entity);
                }
            });
        }
    }

    protected static void putMarker(TextDisplay display) {
        display.getPersistentDataContainer().set(MARKER, PersistentDataType.BYTE, (Object)1);
    }
}

