/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.enums.Option;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.exceptions.StockfishEngineException;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.exceptions.StockfishInitException;

abstract class UCIEngine {
    final BufferedReader input;
    final BufferedWriter output;
    final Process process;
    final OutputStreamWriter directOut;

    UCIEngine(Path path, Map<Option, String> options) throws StockfishInitException {
        try {
            this.process = new ProcessBuilder(new String[0]).command(path.toAbsolutePath().toString()).redirectErrorStream(true).start();
            this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.directOut = new OutputStreamWriter(this.process.getOutputStream());
            this.output = new BufferedWriter(this.directOut);
            this.waitForReady();
            for (Map.Entry<Option, String> option : options.entrySet()) {
                this.passOption(option.getKey(), option.getValue());
            }
        }
        catch (IOException | StockfishEngineException e) {
            throw new StockfishInitException("Unable to start and bind Stockfish process.", e);
        }
    }

    void waitForReady() {
        this.sendCommand("isready");
        this.readUntil("readyok");
    }

    void uciNewGame() {
        this.sendCommand("ucinewgame");
        this.waitForReady();
    }

    void sendCommand(String command) {
        try {
            if ("quit".equals(command)) {
                this.directOut.write(command + "\n");
                return;
            }
            this.output.write(command + "\n");
            this.output.flush();
        }
        catch (IOException e) {
            throw new StockfishEngineException(e);
        }
    }

    String readLine(String expected) {
        List<String> output = this.readUntil(expected);
        return output.get(output.size() - 1);
    }

    List<String> readUntil(String expected) {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            boolean isPresent = false;
            while ((line = this.input.readLine()) != null) {
                lines.add(line);
                if (!line.startsWith(expected)) continue;
                isPresent = true;
                break;
            }
            if (isPresent) {
                return lines;
            }
            throw new StockfishEngineException("Can not find expected line: '" + expected + "' in output:\n  " + String.join((CharSequence)"\n  ", lines));
        }
        catch (IOException e) {
            throw new StockfishEngineException(e);
        }
    }

    protected void passOption(Option option, String value) {
        this.sendCommand("setoption name " + option.optionString + " value " + value);
    }
}

