/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.Query;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.QueryTypes;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.Stockfish;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.enums.Option;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.exceptions.StockfishEngineException;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.exceptions.StockfishInitException;

public class StockfishClient {
    private static final Logger LOGGER = LogManager.getLogger(StockfishClient.class);
    private final ExecutorService queryExecutor = Executors.newSingleThreadExecutor();
    private final Stockfish engine;

    private StockfishClient(Path path, Map<Option, String> options) throws StockfishInitException {
        this.engine = new Stockfish(path, options);
    }

    public <R> CompletableFuture<R> submit(Query<R> query) {
        return CompletableFuture.supplyAsync(() -> {
            if (query.getType() == QueryTypes.BEST_MOVE) {
                return this.engine.getBestMove(query);
            }
            if (query.getType() == QueryTypes.MAKE_MOVES) {
                return this.engine.makeMoves(query);
            }
            if (query.getType() == QueryTypes.LEGAL_MOVES) {
                return this.engine.getLegalMoves(query);
            }
            if (query.getType() == QueryTypes.CHECKERS) {
                return this.engine.getCheckers(query);
            }
            throw new IllegalArgumentException(query.toString());
        }, this.queryExecutor);
    }

    public CompletableFuture<Void> uciNewGame() {
        return CompletableFuture.runAsync(this.engine::uciNewGame, this.queryExecutor);
    }

    public void close() throws StockfishEngineException {
        StockfishClient.awaitTerminationAfterShutdown(this.queryExecutor);
        AtomicBoolean error = new AtomicBoolean(false);
        AtomicReference<Exception> ex = new AtomicReference<Exception>();
        try {
            this.engine.close();
        }
        catch (IOException | StockfishEngineException e) {
            ex.set(e);
            error.compareAndSet(false, true);
            LOGGER.fatal("Can not stop Stockfish. Please, close it manually.", (Throwable)e);
        }
        if (error.get()) {
            throw new StockfishEngineException("Error while closing Stockfish threads", (Throwable)ex.get());
        }
    }

    private static void awaitTerminationAfterShutdown(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            if (!threadPool.awaitTermination(1L, TimeUnit.SECONDS)) {
                threadPool.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            threadPool.shutdownNow();
        }
    }

    public static class Builder {
        private final Map<Option, String> options = new HashMap<Option, String>();
        private Path path = null;

        public final Builder setOption(Option o, Object value) {
            this.options.put(o, value.toString());
            return this;
        }

        public final Builder setPath(Path path) {
            this.path = path;
            return this;
        }

        public final StockfishClient build() throws StockfishInitException {
            return new StockfishClient(this.path, this.options);
        }
    }
}

