/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.Query;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.UCIEngine;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.enums.Option;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.exceptions.StockfishInitException;

class Stockfish
extends UCIEngine {
    Stockfish(Path path, Map<Option, String> options) throws StockfishInitException {
        super(path, options);
    }

    String makeMoves(Query<?> query) {
        this.waitForReady();
        this.sendCommand("position fen " + query.getFen() + " moves " + query.getMoves());
        return this.getFen();
    }

    String getCheckers(Query<?> query) {
        this.waitForReady();
        this.sendCommand("position fen " + query.getFen());
        this.waitForReady();
        this.sendCommand("d");
        return this.readLine("Checkers: ").substring(10);
    }

    String getBestMove(Query<?> query) {
        if (query.getDifficulty() >= 0) {
            this.waitForReady();
            this.sendCommand("setoption name Skill Level value " + query.getDifficulty());
        } else if (query.getUciElo() >= 0) {
            this.waitForReady();
            this.passOption(Option.UCI_LIMITSTRENGTH, "true");
            this.passOption(Option.UCI_ELO, String.valueOf(query.getUciElo()));
        }
        this.waitForReady();
        String cmd = "position fen " + query.getFen();
        if (query.getMoves() != null && !query.getMoves().isBlank()) {
            cmd = cmd + " moves " + query.getMoves();
        }
        this.sendCommand(cmd);
        StringBuilder command = new StringBuilder("go ");
        if (query.getDepth() >= 0) {
            command.append("depth ").append(query.getDepth()).append(" ");
        }
        if (query.getMovetime() >= 0L) {
            command.append("movetime ").append(query.getMovetime());
        }
        this.waitForReady();
        this.sendCommand(command.toString());
        return this.readLine("bestmove").substring(9).split("\\s+")[0];
    }

    Set<String> getLegalMoves(Query<?> query) {
        this.waitForReady();
        String cmd = "position fen " + query.getFen();
        if (query.getMoves() != null && !query.getMoves().isBlank()) {
            cmd = cmd + " moves " + query.getMoves();
        }
        this.sendCommand(cmd);
        this.waitForReady();
        this.sendCommand("go perft 1");
        HashSet<String> legal = new HashSet<String>();
        List<String> response = this.readUntil("Nodes");
        for (String line : response) {
            if (line.contains("Nodes") || !line.contains(":")) continue;
            legal.add(line.split(":")[0]);
        }
        return Set.copyOf(legal);
    }

    void close() throws IOException {
        try {
            this.sendCommand("quit");
        }
        finally {
            if (this.process.isAlive()) {
                this.process.destroy();
            }
        }
    }

    private String getFen() {
        this.waitForReady();
        this.sendCommand("d");
        return this.readLine("Fen: ").substring(5);
    }
}

