/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine;

import java.util.regex.Pattern;
import xyz.jpenilla.chesscraft.dependency.xyz.niflheim.stockfish.engine.QueryType;

public class Query<R> {
    private final QueryType<R> type;
    private final String fen;
    private final String moves;
    private final int difficulty;
    private final int depth;
    private final long movetime;
    private final int uciElo;

    public Query(QueryType<R> type, String fen, int difficulty, int depth, long movetime, int uciElo) {
        this.type = type;
        this.fen = fen;
        this.moves = null;
        this.difficulty = difficulty;
        this.depth = depth;
        this.movetime = movetime;
        this.uciElo = uciElo;
    }

    public Query(QueryType<R> type, String fen, String moves, int difficulty, int depth, long movetime, int uciElo) {
        this.type = type;
        this.fen = fen;
        this.moves = moves;
        this.difficulty = difficulty;
        this.depth = depth;
        this.movetime = movetime;
        this.uciElo = uciElo;
    }

    public QueryType<R> getType() {
        return this.type;
    }

    public String getFen() {
        return this.fen;
    }

    public String getMoves() {
        return this.moves;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getDepth() {
        return this.depth;
    }

    public long getMovetime() {
        return this.movetime;
    }

    public int getUciElo() {
        return this.uciElo;
    }

    public static class Builder<R> {
        private static final String START_REGEX = "^";
        private static final String END_REGEX = "$";
        private static final String FEN_REGEX = "(([rnbqkp1-8PRNBQK]{1,8}/){7}[rnbqkp1-8PRNBQK]{1,8})(\\s)([wb])(\\s[-kqKQ]{1,4}\\s)((-)|[a-h][1-8])(\\s)([0-9]+)(\\s)([0-9]+)";
        private static final String MOVE_REGEX = "([a-h][1-8]){2}[qnrb]?";
        private static final Pattern fenPattern = Pattern.compile("^(([rnbqkp1-8PRNBQK]{1,8}/){7}[rnbqkp1-8PRNBQK]{1,8})(\\s)([wb])(\\s[-kqKQ]{1,4}\\s)((-)|[a-h][1-8])(\\s)([0-9]+)(\\s)([0-9]+)$");
        private static final Pattern movePattern = Pattern.compile("^([a-h][1-8]){2}[qnrb]?$");
        private final QueryType<R> type;
        private final String fen;
        private String moves;
        private int difficulty = -1;
        private int depth = -1;
        private long movetime = -1L;
        private int uciElo = -1;

        public Builder(QueryType<R> type, String fen) {
            this.fen = fen;
            this.type = type;
        }

        public Builder<R> setMoves(String moves) throws IllegalArgumentException {
            if (moves == null) {
                throw new IllegalArgumentException("Move cannot be null");
            }
            this.moves = moves;
            return this;
        }

        public Builder<R> setDifficulty(int difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        public Builder<R> setDepth(int depth) {
            this.depth = depth;
            return this;
        }

        public Builder<R> setMovetime(long movetime) {
            this.movetime = movetime;
            return this;
        }

        public Builder<R> setUciElo(int uciElo) {
            this.uciElo = uciElo;
            return this;
        }

        public Query<R> build() throws IllegalArgumentException, IllegalStateException {
            if (this.type == null) {
                throw new IllegalStateException("Query type can not be null.");
            }
            if (this.fen == null) {
                throw new IllegalStateException("Query is missing FEN.");
            }
            if (!fenPattern.matcher(this.fen).matches()) {
                throw new IllegalArgumentException("Incorrect FEN in Query: " + this.fen);
            }
            if (this.moves != null) {
                return new Query<R>(this.type, this.fen, this.moves, this.difficulty, this.depth, this.movetime, this.uciElo);
            }
            return new Query<R>(this.type, this.fen, this.difficulty, this.depth, this.movetime, this.uciElo);
        }
    }
}

