/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Util {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private Util() {
    }

    public static void shutdownExecutor(ExecutorService service, TimeUnit timeoutUnit, long timeoutLength) {
        boolean didShutdown;
        service.shutdown();
        try {
            didShutdown = service.awaitTermination(timeoutLength, timeoutUnit);
        }
        catch (InterruptedException ignore) {
            didShutdown = false;
        }
        if (!didShutdown) {
            service.shutdownNow();
        }
    }

    public static Path mkParentDirs(Path path) throws IOException {
        block3: {
            Path parent = path.getParent();
            if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    if (Files.isDirectory(parent, new LinkOption[0])) break block3;
                    throw ex;
                }
            }
        }
        return path;
    }

    public static <X extends Throwable> RuntimeException rethrow(Throwable t) throws X {
        throw t;
    }

    public static URL classpathUrl(Class<?> cls) {
        try {
            int exclamationIdx;
            URL sourceUrl = cls.getProtectionDomain().getCodeSource().getLocation();
            if (sourceUrl.getProtocol().equals("jar") && (exclamationIdx = sourceUrl.getPath().lastIndexOf(33)) != -1) {
                sourceUrl = new URL(sourceUrl.getPath().substring(0, exclamationIdx));
            }
            return sourceUrl;
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Could not locate classpath of " + cls.getName(), ex);
        }
    }

    public static <T extends Comparable<T>> List<T> sorted(Collection<T> list) {
        ArrayList<T> sorted = new ArrayList<T>(list);
        sorted.sort(null);
        return Collections.unmodifiableList(sorted);
    }

    public static String asHexString(byte[] bytes) {
        char[] chars = new char[2 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int unsigned = b & 0xFF;
            chars[2 * i] = HEX_CHARS[unsigned / 16];
            chars[2 * i + 1] = HEX_CHARS[unsigned % 16];
        }
        return new String(chars);
    }
}

