/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.util.HashResult;
import xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.util.HashingAlgorithm;

@NullMarked
public final class MultiAlgorithmHasher {
    private final HashingAlgorithm[] algorithms;

    public MultiAlgorithmHasher(HashingAlgorithm ... algorithm) {
        this.algorithms = algorithm;
        if (this.algorithms.length == 0) {
            throw new IllegalArgumentException("No algorithms provided");
        }
        for (HashingAlgorithm algo : this.algorithms) {
            Objects.requireNonNull(algo);
        }
    }

    public HashesMap hashString(String s) {
        HashesMapImpl resultMap = new HashesMapImpl(this.algorithms.length);
        for (HashingAlgorithm algo : this.algorithms) {
            resultMap.put(algo, algo.hashString(s));
        }
        return resultMap;
    }

    public HashesMap hashFile(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            HashesMap hashesMap = this.hash(in);
            return hashesMap;
        }
    }

    public HashesMap hash(InputStream stream) throws IOException {
        int count;
        MessageDigest[] digests = new MessageDigest[this.algorithms.length];
        for (int i = 0; i < this.algorithms.length; ++i) {
            digests[i] = this.algorithms[i].digest();
        }
        byte[] buffer = new byte[8192];
        while ((count = stream.read(buffer)) != -1) {
            for (MessageDigest digest : digests) {
                digest.update(buffer, 0, count);
            }
        }
        HashesMapImpl resultMap = new HashesMapImpl(digests.length);
        for (int i = 0; i < digests.length; ++i) {
            HashingAlgorithm algo = this.algorithms[i];
            MessageDigest digest = digests[i];
            resultMap.put(algo, new HashResult(digest.digest()));
        }
        return resultMap;
    }

    private static final class HashesMapImpl
    extends HashMap<HashingAlgorithm, HashResult>
    implements HashesMap {
        HashesMapImpl(int size) {
            super(size);
        }

        @Override
        public HashResult hash(HashingAlgorithm algo) {
            return Objects.requireNonNull((HashResult)this.get(algo), "Missing " + algo.algorithmName() + " hash");
        }
    }

    public static interface HashesMap
    extends Map<HashingAlgorithm, HashResult> {
        public HashResult hash(HashingAlgorithm var1);
    }
}

