/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.Dependency;
import xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.Extension;
import xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.RelocationExtension;

@NullMarked
public record DependencySet(List<String> repositories, List<Dependency> dependencies, Map<String, Extension<?>> extensions, Map<String, ?> extensionData) {
    <S> @Nullable S extensionData(String name) {
        @Nullable ? o = this.extensionData.get(name);
        if (o == null) {
            return null;
        }
        return (S)o;
    }

    public static Map<String, Extension<?>> defaultExtensions() {
        return Map.of("relocation", new RelocationExtension());
    }

    public static DependencySet readDefault(ClassLoader loader) {
        return DependencySet.readDefault(loader, DependencySet.defaultExtensions());
    }

    public static DependencySet readDefault(ClassLoader loader, Map<String, Extension<?>> extensions) {
        return DependencySet.readFromClasspathResource(loader, "dependencies.txt", extensions);
    }

    public static DependencySet readFromClasspathResource(ClassLoader loader, String resourceName) {
        return DependencySet.readFromClasspathResource(loader, resourceName, DependencySet.defaultExtensions());
    }

    public static DependencySet readFromClasspathResource(ClassLoader loader, String resourceName, Map<String, Extension<?>> extensions) {
        DependencySet dependencySet;
        block8: {
            InputStream stream = Objects.requireNonNull(loader.getResourceAsStream(resourceName), "Could not get InputStream for " + resourceName);
            try {
                dependencySet = DependencySet.read(stream, extensions);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to read dependency set " + resourceName, ex);
                }
            }
            stream.close();
        }
        return dependencySet;
    }

    public static DependencySet read(InputStream inputStream) throws IOException {
        return DependencySet.read(inputStream, DependencySet.defaultExtensions());
    }

    public static DependencySet read(InputStream inputStream, Map<String, Extension<?>> extensions) throws IOException {
        ArrayList<String> repositories = new ArrayList<String>();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        LinkedHashMap<String, List<String>> extraSections = new LinkedHashMap<String, List<String>>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            String currentSection = null;
            block13: while ((line = reader.readLine()) != null) {
                if (line.equals("__end__")) {
                    if (currentSection == null) {
                        throw new IllegalStateException("Encountered section end when not in a section");
                    }
                    currentSection = null;
                    continue;
                }
                if (line.startsWith("__") && line.endsWith("__")) {
                    if (currentSection != null) {
                        throw new IllegalStateException("Encountered section header when already in a section");
                    }
                    currentSection = line.substring(2, line.length() - 2);
                    continue;
                }
                if (currentSection == null) {
                    throw new IllegalStateException("Received content when not in a section");
                }
                switch (currentSection) {
                    case "repos": {
                        repositories.add(line);
                        continue block13;
                    }
                    case "deps": {
                        String[] split = line.split(" ");
                        dependencies.add(Dependency.parse(split[0], split[1]));
                        continue block13;
                    }
                }
                extraSections.computeIfAbsent(currentSection, $ -> new ArrayList()).add(line);
            }
        }
        return new DependencySet(repositories, dependencies, extensions, DependencySet.parseExtensionConfigs(extensions, extraSections));
    }

    private static Map<String, ?> parseExtensionConfigs(Map<String, Extension<?>> extensions, Map<String, List<String>> extraSections) {
        LinkedHashMap ret = new LinkedHashMap();
        for (Map.Entry<String, List<String>> entry : extraSections.entrySet()) {
            @Nullable Extension<?> extension = extensions.get(entry.getKey());
            if (extension == null) {
                throw new IllegalStateException("No such extension '" + entry.getKey() + "'");
            }
            ret.put(entry.getKey(), extension.parseConfig(entry.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }
}

