/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.LocaleExtractor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.ResourceBundleTranslatedCaptionProvider;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.TranslatedCaptionProvider;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.TranslationBundle;

@API(status=API.Status.INTERNAL)
final class ResourceBundleTranslationBundle<C>
implements TranslationBundle<C> {
    private final String key;
    private final LocaleExtractor<C> localeExtractor;
    private final ClassLoader classLoader;
    private final Map<Locale, TranslatedCaptionProvider<C>> translations = new HashMap<Locale, TranslatedCaptionProvider<C>>();

    ResourceBundleTranslationBundle(@NonNull String baseName, @NonNull LocaleExtractor<C> localeExtractor, @NonNull ClassLoader classLoader) {
        this.key = Objects.requireNonNull(baseName, "baseName");
        this.localeExtractor = Objects.requireNonNull(localeExtractor, "localeExtractor");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
    }

    @Override
    public @NonNull LocaleExtractor<C> localeExtractor() {
        return this.localeExtractor;
    }

    @Override
    public synchronized @Nullable TranslatedCaptionProvider<C> translations(@NonNull Locale locale) {
        TranslatedCaptionProvider translatedCaptionProvider = this.translations.computeIfAbsent(locale, this::loadTranslations);
        if (translatedCaptionProvider.isEmpty()) {
            return null;
        }
        return translatedCaptionProvider;
    }

    private @NonNull TranslatedCaptionProvider<C> loadTranslations(@NonNull Locale locale) {
        try {
            return new ResourceBundleTranslatedCaptionProvider(ResourceBundle.getBundle(this.key, locale, this.classLoader, new Control()), locale);
        }
        catch (MissingResourceException ignored) {
            return TranslatedCaptionProvider.empty();
        }
    }

    private final class Control
    extends ResourceBundle.Control {
        private final List<String> availableLocales;

        Control() {
            CharSequence[] split = ResourceBundleTranslationBundle.this.key.replace(".", "/").split("/");
            String last = split[split.length - 1];
            split[split.length - 1] = last + "-locales.list";
            String path = String.join((CharSequence)"/", split);
            @Nullable URL url = ResourceBundleTranslationBundle.this.classLoader.getResource(path);
            if (url == null) {
                this.availableLocales = List.of();
                return;
            }
            try {
                URLConnection conn = url.openConnection();
                try (InputStream s = conn.getInputStream();){
                    this.availableLocales = new BufferedReader(new InputStreamReader(new BufferedInputStream(s))).lines().toList();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Exception reading " + path, e);
            }
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> originalCandidates = super.getCandidateLocales(baseName, locale);
            if (this.availableLocales.isEmpty()) {
                return originalCandidates;
            }
            String base = null;
            int noCountry = -1;
            for (int i = 0; i < originalCandidates.size(); ++i) {
                Locale candidate = originalCandidates.get(i);
                if (candidate.getCountry().isBlank()) {
                    base = candidate.getLanguage();
                    noCountry = i + 1;
                    break;
                }
                if (candidate != Locale.ROOT) continue;
                return originalCandidates;
            }
            ArrayList<Locale> locales = new ArrayList<Locale>(originalCandidates);
            if (base != null) {
                for (String localeString : this.availableLocales) {
                    if (!localeString.startsWith(base + "_")) continue;
                    String[] split = localeString.split("_");
                    locales.add(noCountry, new Locale(split[0], split[1]));
                }
            }
            return new ArrayList<Locale>(new LinkedHashSet<Locale>(locales));
        }
    }
}

