/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.GenericTypeReflector;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.translations.LocaleExtractor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.type.tuple.Pair;

final class LocaleExtractorBuilderImpl<C>
implements LocaleExtractor.Builder<C> {
    private @NonNull LocaleExtractor<C> fallback = $ -> Locale.getDefault();
    private final LinkedList<Pair<Type, Function<Object, @Nullable Locale>>> extractors = new LinkedList();

    LocaleExtractorBuilderImpl() {
    }

    @Override
    public @NonNull LocaleExtractor.Builder<C> fallback(@NonNull LocaleExtractor<C> fallback) {
        this.fallback = Objects.requireNonNull(fallback);
        return this;
    }

    @Override
    public <S extends C> @NonNull LocaleExtractor.Builder<C> senderType(@NonNull TypeToken<S> senderType, @NonNull Function<S, @Nullable Locale> extractor) {
        this.extractors.addFirst(Pair.of(senderType.getType(), extractor));
        return this;
    }

    @Override
    public @NonNull LocaleExtractor<C> build() {
        LocaleExtractor fallback = this.fallback;
        List<Pair<Type, Function<Object, Locale>>> extractors = List.copyOf(this.extractors);
        return recipient -> {
            for (Pair pair : extractors) {
                Locale apply;
                if (!GenericTypeReflector.isSuperType((Type)((Type)pair.first()), recipient.getClass()) || (apply = (Locale)((Function)pair.second()).apply(recipient)) == null) continue;
                return apply;
            }
            return fallback.extract(recipient);
        };
    }
}

