/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard;

import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.component.CommandComponent;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.exception.parsing.NumberParseException;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.NumberParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.type.range.FloatRange;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.type.range.Range;

@API(status=API.Status.STABLE)
public final class FloatParser<C>
extends NumberParser<C, Float, FloatRange> {
    @API(status=API.Status.STABLE)
    public static final float DEFAULT_MINIMUM = Float.NEGATIVE_INFINITY;
    @API(status=API.Status.STABLE)
    public static final float DEFAULT_MAXIMUM = Float.POSITIVE_INFINITY;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Float> floatParser() {
        return FloatParser.floatParser(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Float> floatParser(float minValue) {
        return ParserDescriptor.of(new FloatParser<C>(minValue, Float.POSITIVE_INFINITY), Float.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Float> floatParser(float minValue, float maxValue) {
        return ParserDescriptor.of(new FloatParser<C>(minValue, maxValue), Float.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Float> floatComponent() {
        return CommandComponent.builder().parser(FloatParser.floatParser());
    }

    public FloatParser(float min, float max) {
        super(Range.floatRange(min, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Float> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidFloat((FloatRange)this.range())) {
            return ArgumentParseResult.failure(new FloatParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(Float.valueOf(commandInput.readFloat()));
    }

    @Override
    public boolean hasMax() {
        return ((FloatRange)this.range()).maxFloat() != Float.POSITIVE_INFINITY;
    }

    @Override
    public boolean hasMin() {
        return ((FloatRange)this.range()).minFloat() != Float.NEGATIVE_INFINITY;
    }

    @API(status=API.Status.STABLE)
    public static final class FloatParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public FloatParseException(@NonNull String input, @NonNull FloatParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "float";
        }
    }
}

