/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard;

import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.caption.CaptionVariable;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.caption.StandardCaptionKeys;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.component.CommandComponent;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.exception.parsing.ParserException;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ParserDescriptor;

@API(status=API.Status.STABLE)
public final class CharacterParser<C>
implements ArgumentParser<C, Character> {
    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Character> characterParser() {
        return ParserDescriptor.of(new CharacterParser<C>(), Character.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Character> characterComponent() {
        return CommandComponent.builder().parser(CharacterParser.characterParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Character> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (commandInput.peekString().length() != 1) {
            return ArgumentParseResult.failure(new CharParseException(commandInput.peekString(), commandContext));
        }
        return ArgumentParseResult.success(Character.valueOf(commandInput.read()));
    }

    @API(status=API.Status.STABLE)
    public static final class CharParseException
    extends ParserException {
        private final String input;

        public CharParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(CharacterParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_CHAR, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharParseException that = (CharParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

