/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.ShadowColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ARGBLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationOptions;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.TypeSerializer;

final class StyleSerializer
implements TypeSerializer<Style> {
    static final StyleSerializer INSTANCE = new StyleSerializer();
    private static final TextDecoration[] DECORATIONS = TextDecoration.values();
    static final TypeToken<HoverEvent.Action<?>> HOVER_EVENT_ACTION_TYPE = new TypeToken<HoverEvent.Action<?>>(){};

    private StyleSerializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Style deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        ConfigurationNode hoverEvent;
        ConfigurationNode clickEvent;
        ShadowColor shadowColor;
        TextColor color;
        if (value.virtual()) {
            return Style.empty();
        }
        Style.Builder builder = Style.style();
        @Nullable Key font = value.node("font").get(Key.class);
        if (font != null) {
            builder.font(font);
        }
        if ((color = value.node("color").get(TextColor.class)) != null) {
            builder.color(color);
        }
        if ((shadowColor = value.node("shadow_color").get(ShadowColor.class)) != null) {
            builder.shadowColor((ARGBLike)shadowColor);
        }
        for (TextDecoration decoration : DECORATIONS) {
            TextDecoration.State state = value.node(StyleSerializer.nonNull((String)TextDecoration.NAMES.key((Object)decoration), "decoration")).get(TextDecoration.State.class);
            if (state == null) continue;
            builder.decoration(decoration, state);
        }
        @Nullable String insertion = value.node("insertion").getString();
        if (insertion != null) {
            builder.insertion(insertion);
        }
        if (!(clickEvent = value.node("clickEvent")).virtual()) {
            ClickEvent.Action action = StyleSerializer.nonNull(clickEvent.node("action").get(ClickEvent.Action.class), "click event action");
            builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)action, (String)StyleSerializer.nonNull(clickEvent.node("value").getString(), "click event value")));
        }
        if ((hoverEvent = value.node("hoverEvent")).virtual()) return builder.build();
        HoverEvent.Action<?> action = hoverEvent.node("action").get(HOVER_EVENT_ACTION_TYPE);
        ConfigurationNode contents = hoverEvent.node("contents");
        if (contents.virtual()) {
            Component legacyValue = hoverEvent.node("value").get(Component.class);
            if (legacyValue == null) {
                throw new SerializationException("No modern contents or legacy value present for hover event");
            }
            if (action != HoverEvent.Action.SHOW_TEXT) throw new SerializationException("Unable to deserialize legacy hover event of type " + action);
            builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)legacyValue));
            return builder.build();
        } else if (action == HoverEvent.Action.SHOW_TEXT) {
            builder.hoverEvent((HoverEventSource)HoverEvent.showText((Component)StyleSerializer.nonNull(contents.get(Component.class), "hover event text contents")));
            return builder.build();
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            builder.hoverEvent((HoverEventSource)HoverEvent.showEntity((HoverEvent.ShowEntity)StyleSerializer.nonNull(contents.get(HoverEvent.ShowEntity.class), "hover event show entity contents")));
            return builder.build();
        } else {
            if (action != HoverEvent.Action.SHOW_ITEM) throw new SerializationException("Unsupported hover event action " + action);
            builder.hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)StyleSerializer.nonNull(contents.get(HoverEvent.ShowItem.class), "hover event show item contents")));
        }
        return builder.build();
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Style obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            obj = Style.empty();
        }
        value.node("font").set(Key.class, obj.font());
        value.node("color").set(TextColor.class, obj.color());
        value.node("shadow_color").set(ShadowColor.class, obj.shadowColor());
        for (TextDecoration decoration : DECORATIONS) {
            ConfigurationNode decorationNode = value.node(StyleSerializer.nonNull((String)TextDecoration.NAMES.key((Object)decoration), "decoration"));
            TextDecoration.State state = obj.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) {
                decorationNode.set(null);
                continue;
            }
            decorationNode.set(state == TextDecoration.State.TRUE);
        }
        value.node("insertion").set(obj.insertion());
        ConfigurationNode clickNode = value.node("clickEvent");
        ClickEvent clickEvent = obj.clickEvent();
        if (clickEvent == null) {
            clickNode.set(null);
        } else {
            clickNode.node("action").set(ClickEvent.Action.class, clickEvent.action());
            clickNode.node("value").set(clickEvent.value());
        }
        ConfigurationNode hoverNode = value.node("hoverEvent");
        if (obj.hoverEvent() == null) {
            hoverNode.set(null);
        } else {
            HoverEvent event = obj.hoverEvent();
            hoverNode.node("action").set(HOVER_EVENT_ACTION_TYPE, event.action());
            ConfigurationNode contentsNode = hoverNode.node("contents");
            if (event.action() == HoverEvent.Action.SHOW_TEXT) {
                contentsNode.set(Component.class, (Component)event.value());
            } else if (event.action() == HoverEvent.Action.SHOW_ENTITY) {
                contentsNode.set(HoverEvent.ShowEntity.class, (HoverEvent.ShowEntity)event.value());
            } else if (event.action() == HoverEvent.Action.SHOW_ITEM) {
                contentsNode.set(HoverEvent.ShowItem.class, (HoverEvent.ShowItem)event.value());
            }
        }
    }

    @NotNull
    private static <T> T nonNull(@Nullable T value, @NotNull String type) throws SerializationException {
        if (value == null) {
            throw new SerializationException(type + " was null in an unexpected location");
        }
        return value;
    }

    @Override
    public Style emptyValue(Type specificType, ConfigurationOptions options) {
        return Style.empty();
    }
}

