/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.OptionalLong;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.TypeSerializer;

final class SoundSerializer
implements TypeSerializer<Sound> {
    static final SoundSerializer INSTANCE = new SoundSerializer();
    static final String NAME = "name";
    static final String SOURCE = "source";
    static final String PITCH = "pitch";
    static final String VOLUME = "volume";
    static final String SEED = "seed";

    private SoundSerializer() {
    }

    @Override
    @Nullable
    public Sound deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Sound.Builder builder = Sound.sound();
        Key name = value.node(NAME).get(Key.class);
        Sound.Source source = value.node(SOURCE).get(Sound.Source.class);
        if (name == null || source == null) {
            throw new SerializationException("A name and source are required to deserialize a Sound");
        }
        builder.type(name).source(source).volume(value.node(VOLUME).getFloat(1.0f)).pitch(value.node(PITCH).getFloat(1.0f));
        ConfigurationNode seed = value.node(SEED);
        if (!seed.virtual()) {
            builder.seed(OptionalLong.of(seed.getLong()));
        }
        return (Sound)builder.build();
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Sound obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(NAME).set(Key.class, obj.name());
        value.node(SOURCE).set(Sound.Source.class, obj.source());
        value.node(VOLUME).set(Float.valueOf(obj.volume()));
        value.node(PITCH).set(Float.valueOf(obj.pitch()));
        if (obj.seed().isPresent()) {
            value.node(SEED).set(obj.seed().getAsLong());
        } else {
            value.node(SEED).set(null);
        }
    }
}

