/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.format.ShadowColor;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.TypeSerializer;

final class ShadowColorSerializer
implements TypeSerializer<ShadowColor> {
    static final TypeSerializer<ShadowColor> INSTACE = new ShadowColorSerializer(false);
    private boolean emitFloats;

    private ShadowColorSerializer(boolean emitFloats) {
        this.emitFloats = emitFloats;
    }

    @Override
    public ShadowColor deserialize(Type type, ConfigurationNode node) throws SerializationException {
        if (node.isList()) {
            List<Float> floats = node.getList(Float.class);
            if (floats.size() != 4) {
                throw new SerializationException(node, (Type)((Object)ShadowColor.class), "Expected a 4-element float array ([R, G, B, A]), but got a " + floats.size() + "-long array instead.");
            }
            int r = ShadowColorSerializer.componentFromFloat(floats.get(0).floatValue());
            int g = ShadowColorSerializer.componentFromFloat(floats.get(1).floatValue());
            int b = ShadowColorSerializer.componentFromFloat(floats.get(2).floatValue());
            int a = ShadowColorSerializer.componentFromFloat(floats.get(3).floatValue());
            return ShadowColor.shadowColor((int)r, (int)g, (int)b, (int)a);
        }
        return ShadowColor.shadowColor((int)node.getInt());
    }

    @Override
    public void serialize(Type type, @Nullable ShadowColor obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.raw(null);
            return;
        }
        if (this.emitFloats) {
            node.set(Collections.emptyList());
            node.appendListNode().set(Float.valueOf(ShadowColorSerializer.componentAsFloat(obj.red())));
            node.appendListNode().set(Float.valueOf(ShadowColorSerializer.componentAsFloat(obj.green())));
            node.appendListNode().set(Float.valueOf(ShadowColorSerializer.componentAsFloat(obj.blue())));
            node.appendListNode().set(Float.valueOf(ShadowColorSerializer.componentAsFloat(obj.alpha())));
        } else {
            node.set(obj.value());
        }
    }

    static float componentAsFloat(int element) {
        return (float)element / 255.0f;
    }

    static int componentFromFloat(double element) {
        return (int)((float)element * 255.0f);
    }
}

