/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.BlockNBTComponent;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.EntityNBTComponent;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.NBTComponentBuilder;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.StorageNBTComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4.BlockNBTPosSerializer;
import xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4.KeySerializer;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.TypeSerializer;

final class ComponentTypeSerializer
implements TypeSerializer<Component> {
    static final TypeToken<List<Component>> LIST_TYPE = new TypeToken<List<Component>>(){};
    @Nullable
    private final ComponentSerializer<Component, ? extends Component, String> stringSerial;
    private final boolean preferString;

    ComponentTypeSerializer(@Nullable ComponentSerializer<Component, ? extends Component, String> stringSerial, boolean preferString) {
        this.stringSerial = stringSerial;
        this.preferString = preferString;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        return this.deserialize0(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private BuildableComponent<?, ?> deserialize0(@NotNull ConfigurationNode value) throws SerializationException {
        Style style;
        TextComponent.Builder component;
        Map<Object, ? extends ConfigurationNode> children;
        if (!value.isList() && !value.isMap()) {
            String str = value.getString();
            if (str != null) {
                if (this.stringSerial == null) return Component.text((String)str);
                Component ret = this.stringSerial.deserialize((Object)str);
                if (ret instanceof BuildableComponent) return (BuildableComponent)ret;
                throw new SerializationException("Result " + ret + " is not builable");
            }
        } else {
            if (value.isList()) {
                ComponentBuilder parent = null;
                for (ConfigurationNode configurationNode : value.childrenList()) {
                    BuildableComponent<?, ?> child = this.deserialize0(configurationNode);
                    if (parent == null) {
                        parent = child.toBuilder();
                        continue;
                    }
                    parent.append(child);
                }
                if (parent != null) return parent.build();
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
            if (!value.isMap()) {
                throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            }
        }
        if ((children = value.childrenMap()).containsKey("text")) {
            component = Component.text().content(children.get("text").getString());
        } else if (children.containsKey("translate")) {
            TranslatableComponent.Builder builder = Component.translatable().key(children.get("translate").getString());
            if (children.containsKey("with")) {
                ConfigurationNode with = children.get("with");
                if (!with.isList()) {
                    throw new SerializationException("Expected with to be a list");
                }
                List<TranslationArgument> list = with.getList(TranslationArgument.class);
                builder.arguments(list);
            }
            if (children.containsKey("fallback")) {
                builder.fallback(children.get("fallback").getString());
            }
            component = builder;
        } else if (children.containsKey("score")) {
            ConfigurationNode configurationNode = children.get("score");
            ConfigurationNode name = configurationNode.node("name");
            ConfigurationNode configurationNode2 = configurationNode.node("objective");
            if (name.virtual() || configurationNode2.virtual()) {
                throw new SerializationException("A score component requires a name and objective");
            }
            ScoreComponent.Builder builder = Component.score().name(name.getString()).objective(configurationNode2.getString());
            ConfigurationNode scoreValue = configurationNode.node("value");
            component = !scoreValue.virtual() ? builder.value(scoreValue.getString()) : builder;
        } else if (children.containsKey("selector")) {
            component = Component.selector().pattern(children.get("selector").getString());
        } else if (children.containsKey("keybind")) {
            component = Component.keybind().keybind(children.get("keybind").getString());
        } else {
            boolean interpret;
            if (!children.containsKey("nbt")) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
            String string = children.get("nbt").getString();
            boolean bl = interpret = children.containsKey("interpret") && children.get("interpret").getBoolean();
            if (children.containsKey("block")) {
                BlockNBTComponent.Pos pos = (BlockNBTComponent.Pos)children.get("block").get(BlockNBTPosSerializer.INSTANCE.type());
                component = ComponentTypeSerializer.nbt(Component.blockNBT(), string, interpret).pos(pos);
            } else if (children.containsKey("entity")) {
                component = ComponentTypeSerializer.nbt(Component.entityNBT(), string, interpret).selector(children.get("entity").getString());
            } else {
                if (!children.containsKey("storage")) throw ComponentTypeSerializer.notSureHowToDeserialize(value);
                component = ComponentTypeSerializer.nbt(Component.storageNBT(), string, interpret).storage((Key)children.get("storage").get(KeySerializer.INSTANCE.type()));
            }
        }
        if (children.containsKey("extra")) {
            ConfigurationNode configurationNode = children.get("extra");
            for (ConfigurationNode configurationNode3 : configurationNode.childrenList()) {
                component.append(this.deserialize0(configurationNode3));
            }
        }
        if ((style = value.get(Style.class, Style.empty())).isEmpty()) return component.build();
        component.style(style);
        return component.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(@NotNull Type type, @Nullable Component src, @NotNull ConfigurationNode value) throws SerializationException {
        value.set(null);
        if (src == null) {
            return;
        }
        if (this.stringSerial != null && this.preferString) {
            try {
                value.set(this.stringSerial.serialize(src));
                return;
            }
            catch (Exception ex) {
                throw new SerializationException(ex);
            }
        }
        if (src instanceof TextComponent) {
            value.node("text").set(((TextComponent)src).content());
        } else if (src instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)src;
            value.node("translate").set(tc.key());
            if (!tc.arguments().isEmpty()) {
                ConfigurationNode with = value.node("with");
                for (TranslationArgument arg : tc.arguments()) {
                    with.appendListNode().set(TranslationArgument.class, arg);
                }
            }
            value.node("fallback").set(tc.fallback());
        } else if (src instanceof ScoreComponent) {
            ScoreComponent sc = (ScoreComponent)src;
            ConfigurationNode score = value.node("score");
            score.node("name").set(sc.name());
            score.node("objective").set(sc.objective());
            @Nullable String scoreValue = sc.value();
            if (scoreValue != null) {
                score.node("value").set(scoreValue);
            }
        } else if (src instanceof SelectorComponent) {
            value.node("selector").set(((SelectorComponent)src).pattern());
        } else if (src instanceof KeybindComponent) {
            value.node("keybind").set(((KeybindComponent)src).keybind());
        } else {
            if (!(src instanceof NBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
            NBTComponent nc = (NBTComponent)src;
            value.node("nbt").set(nc.nbtPath());
            value.node("interpret").set(nc.interpret());
            if (src instanceof BlockNBTComponent) {
                value.node("block").set(BlockNBTPosSerializer.INSTANCE.type(), ((BlockNBTComponent)nc).pos());
            } else if (src instanceof EntityNBTComponent) {
                value.node("entity").set(((EntityNBTComponent)nc).selector());
            } else {
                if (!(src instanceof StorageNBTComponent)) throw ComponentTypeSerializer.notSureHowToSerialize(src);
                value.node("storage").set(KeySerializer.INSTANCE.type(), ((StorageNBTComponent)nc).storage());
            }
        }
        List children = src.children();
        if (!children.isEmpty()) {
            value.node("extra").set(LIST_TYPE, children);
        }
        if (!src.hasStyling()) return;
        value.set(Style.class, src.style());
    }

    private static <C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>> B nbt(B builder, String nbt, boolean interpret) {
        return (B)builder.nbtPath(nbt).interpret(interpret);
    }

    private static SerializationException notSureHowToDeserialize(ConfigurationNode element) {
        return new SerializationException("Don't know how to turn " + element + " into a Component");
    }

    private static SerializationException notSureHowToSerialize(Component component) {
        return new SerializationException("Don't know how to serialize " + component + " as a Component");
    }
}

