/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.db.type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jdbi.v3.core.argument.AbstractArgumentFactory;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;
import xyz.jpenilla.chesscraft.data.Fen;
import xyz.jpenilla.chesscraft.util.Util;

public abstract class GsonColumnMapper<T>
extends AbstractArgumentFactory<T>
implements ColumnMapper<T> {
    private final Gson gson = ((GsonBuilder)GsonComponentSerializer.gson().populator().apply(new GsonBuilder())).registerTypeAdapter(Fen.class, (Object)new Fen.JsonSerializer()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).create();
    private final Type type;

    public GsonColumnMapper(Type type) {
        super(12);
        this.type = type;
    }

    protected Argument build(T value, ConfigRegistry config) {
        return (position, statement, ctx) -> statement.setString(position, this.gson.toJson(value));
    }

    public T map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        @Nullable String string = Util.trim(r.getString(columnNumber));
        if (string != null) {
            return (T)this.gson.fromJson(string, this.type);
        }
        return null;
    }

    private static final class DurationAdapter
    implements JsonSerializer<Duration>,
    JsonDeserializer<Duration> {
        private DurationAdapter() {
        }

        public Duration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Duration.ofMillis(json.getAsLong());
        }

        public JsonElement serialize(Duration src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.toMillis());
        }
    }
}

