/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.db.type;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.data.Fen;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.util.Util;

public final class GameStateRowMapper
implements RowMapper<GameState> {
    public GameState map(ResultSet rs, StatementContext ctx) throws SQLException {
        GameState.Result result;
        ColumnMapper uuid = (ColumnMapper)ctx.findColumnMapperFor(UUID.class).orElseThrow();
        ColumnMapper tc = (ColumnMapper)ctx.findColumnMapperFor(ChessGame.TimeControl.class).orElseThrow();
        ColumnMapper moveListMapper = (ColumnMapper)ctx.findColumnMapperFor((GenericType)new GenericType<List<ChessGame.Move>>(this){}).orElseThrow();
        ColumnMapper fenMapper = (ColumnMapper)ctx.findColumnMapperFor(Fen.class).orElseThrow();
        ColumnMapper timeControlSettings = (ColumnMapper)ctx.findColumnMapperFor(TimeControlSettings.class).orElseThrow();
        boolean whiteCpu = rs.getBoolean("white_cpu");
        boolean blackCpu = rs.getBoolean("black_cpu");
        try {
            @Nullable String resultType = Util.trim(rs.getString("result_type"));
            if (resultType == null) {
                result = null;
            } else {
                @Nullable String resultColor = Util.trim(rs.getString("result_color"));
                int whiteEloChange = rs.getInt("white_elo_change");
                int blackEloChange = rs.getInt("black_elo_change");
                result = new GameState.Result(GameState.ResultType.valueOf(resultType), resultColor == null ? null : PieceColor.decode(resultColor), whiteEloChange, blackEloChange);
            }
        }
        catch (SQLException e) {
            result = null;
        }
        return new GameState((UUID)uuid.map(rs, "id", ctx), whiteCpu ? null : (UUID)uuid.map(rs, "white_player_id", ctx), whiteCpu ? rs.getInt("white_cpu_elo") : -1, (ChessGame.TimeControl)tc.map(rs, "white_time_control", ctx), blackCpu ? null : (UUID)uuid.map(rs, "black_player_id", ctx), blackCpu ? rs.getInt("black_cpu_elo") : -1, (ChessGame.TimeControl)tc.map(rs, "black_time_control", ctx), (List)moveListMapper.map(rs, "moves", ctx), (Fen)fenMapper.map(rs, "current_fen", ctx), rs.getInt("cpu_move_delay"), (TimeControlSettings)timeControlSettings.map(rs, "time_control_settings", ctx), result, rs.getTimestamp("last_updated"));
    }
}

