/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.db;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.flywaydb.core.Flyway;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.async.JdbiExecutor;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.config.DatabaseSettings;
import xyz.jpenilla.chesscraft.db.QueriesLocator;
import xyz.jpenilla.chesscraft.db.SQLDrivers;
import xyz.jpenilla.chesscraft.db.type.CachedPlayerRowMapper;
import xyz.jpenilla.chesscraft.db.type.ComponentColumnMapper;
import xyz.jpenilla.chesscraft.db.type.FenColumnMapper;
import xyz.jpenilla.chesscraft.db.type.GameStateRowMapper;
import xyz.jpenilla.chesscraft.db.type.MoveListColumnMapper;
import xyz.jpenilla.chesscraft.db.type.NativeUUIDColumnMapper;
import xyz.jpenilla.chesscraft.db.type.TimeControlColumnMapper;
import xyz.jpenilla.chesscraft.db.type.TimeControlSettingsColumnMapper;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.type.tuple.Pair;
import xyz.jpenilla.chesscraft.dependency.xyz.jpenilla.gremlin.runtime.util.Util;
import xyz.jpenilla.chesscraft.util.Elo;

public final class Database
implements Listener {
    private final ChessCraft plugin;
    private final HikariDataSource dataSource;
    private final Jdbi jdbi;
    private final JdbiExecutor jdbiExecutor;
    private final ExecutorService threadPool;
    private final QueriesLocator queries;
    private final AsyncLoadingCache<UUID, ChessPlayer.CachedPlayer> playerCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).buildAsync((key, executor) -> ((CompletableFuture)this.queryPlayer((UUID)key).thenApply(o -> o.orElse(null))).toCompletableFuture());

    private Database(ChessCraft plugin, HikariDataSource dataSource, Jdbi jdbi) {
        this.plugin = plugin;
        this.dataSource = dataSource;
        this.jdbi = jdbi;
        this.threadPool = Executors.newFixedThreadPool(8, Database.threadFactory(plugin, "ChessCraft-JDBI-%d"));
        this.queries = new QueriesLocator();
        this.jdbiExecutor = JdbiExecutor.create((Jdbi)this.jdbi, (Executor)this.threadPool);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.playerCache.synchronous().invalidate((Object)e.getPlayer().getUniqueId());
    }

    private static ThreadFactory threadFactory(ChessCraft plugin, String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setUncaughtExceptionHandler((thr, ex) -> plugin.getSLF4JLogger().warn("Uncaught exception on thread {}", (Object)thr.getName(), (Object)ex)).build();
    }

    public void close() {
        Util.shutdownExecutor(this.threadPool, TimeUnit.SECONDS, 3L);
        this.dataSource.close();
    }

    public CompletableFuture<List<GameState>> queryIncompleteMatches(UUID playerId) {
        return this.jdbiExecutor.withHandle(handle -> ((Query)handle.createQuery(this.queries.query("select_incomplete_matches")).bind("player_id", playerId)).mapTo(GameState.class).list().stream().sorted(Database.newestFirst()).toList()).toCompletableFuture();
    }

    public CompletableFuture<List<GameState>> queryCompleteMatches(UUID playerId) {
        return this.jdbiExecutor.withHandle(handle -> ((Query)handle.createQuery(this.queries.query("select_complete_matches")).bind("player_id", playerId)).mapTo(GameState.class).list().stream().sorted(Database.newestFirst()).toList()).toCompletableFuture();
    }

    public CompletableFuture<Optional<GameState>> queryMatch(UUID id) {
        return this.jdbiExecutor.withHandle(handle -> ((Query)handle.createQuery(this.queries.query("select_match")).bind("id", id)).mapTo(GameState.class).findOne()).toCompletableFuture();
    }

    public CompletableFuture<ChessPlayer.Player> onlineOrCachedPlayer(UUID id) {
        Player player = this.plugin.getServer().getPlayer(id);
        if (player != null) {
            return CompletableFuture.completedFuture(ChessPlayer.player(player));
        }
        return this.playerCache.get((Object)id).thenApply(cached -> {
            if (cached != null) {
                return cached;
            }
            return ChessPlayer.offlinePlayer(Bukkit.getOfflinePlayer((UUID)id));
        });
    }

    public CompletableFuture<Optional<ChessPlayer.CachedPlayer>> queryPlayer(UUID id) {
        return this.jdbiExecutor.withHandle(handle -> this.queryPlayer(id, handle)).toCompletableFuture();
    }

    private Optional<ChessPlayer.CachedPlayer> queryPlayer(UUID id, Handle handle) {
        return ((Query)handle.createQuery(this.queries.query("select_player")).bind("id", id)).mapTo(ChessPlayer.CachedPlayer.class).findOne();
    }

    public CompletableFuture<List<Pair<UUID, Integer>>> queryLeaderboard(int limit) {
        return this.jdbiExecutor.withHandle(handle -> ((Query)handle.createQuery(this.queries.query("query_leaderboard")).bind("limit", limit)).map((rs, ctx) -> Pair.of((UUID)((ColumnMapper)ctx.findColumnMapperFor(UUID.class).orElseThrow()).map(rs, "id", ctx), rs.getInt("rating"))).collectIntoList()).toCompletableFuture();
    }

    public void saveMatchAsync(GameState state, boolean insertResult) {
        if (state.whiteCpu() && state.blackCpu()) {
            return;
        }
        this.threadPool.execute(() -> {
            try {
                this.saveMatch(state, insertResult);
            }
            catch (Exception e) {
                this.plugin.getSLF4JLogger().warn("Failed to save match {}", (Object)state, (Object)e);
            }
        });
    }

    public void saveMatch(GameState state, boolean insertResult) {
        this.jdbi.useTransaction(handle -> {
            EloChange eloChange = this.updatePlayers(state, handle, insertResult);
            ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.queries.query("insert_match")).bind("id", state.id())).bind("white_cpu", state.whiteCpu())).bind("white_cpu_elo", state.whiteElo())).bind("white_player_id", state.whiteId())).bind("white_time_control", (Object)state.whiteTime())).bind("black_cpu", state.blackCpu())).bind("black_cpu_elo", state.blackElo())).bind("black_player_id", state.blackId())).bind("black_time_control", (Object)state.blackTime())).bind("moves", state.moves())).bind("current_fen", (Object)state.currentFen())).bind("cpu_move_delay", state.cpuMoveDelay())).bind("time_control_settings", (Object)state.timeControlSettings())).execute();
            if (insertResult) {
                Objects.requireNonNull(state.result(), "result");
                ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.queries.query("record_result")).bind("id", state.id())).bind("result_type", state.result().type().name())).bind("result_color", state.result().color().encode())).bind("white_elo_change", eloChange.whiteChange())).bind("white_elo", eloChange.whiteElo())).bind("black_elo_change", eloChange.blackChange())).bind("black_elo", eloChange.blackElo())).execute();
            }
        });
    }

    private EloChange updatePlayers(GameState state, Handle handle, boolean insertResult) {
        if (!state.blackCpu() && !state.whiteCpu() && insertResult) {
            Optional<ChessPlayer.CachedPlayer> white = this.queryPlayer(state.whiteId(), handle);
            Elo.RatingData whiteRating = white.map(ChessPlayer.CachedPlayer::ratingData).orElseGet(Elo.RatingData::newPlayer);
            Optional<ChessPlayer.CachedPlayer> black = this.queryPlayer(state.blackId(), handle);
            Elo.RatingData blackRating = black.map(ChessPlayer.CachedPlayer::ratingData).orElseGet(Elo.RatingData::newPlayer);
            Elo.NewRatings newRatings = Elo.computeNewRatings(whiteRating, blackRating, state.matchOutcome());
            this.updatePlayer(handle, state.whiteId(), newRatings.playerOne());
            this.updatePlayer(handle, state.blackId(), newRatings.playerTwo());
            return new EloChange(whiteRating.rating(), newRatings.playerOne().rating() - whiteRating.rating(), blackRating.rating(), newRatings.playerTwo().rating() - blackRating.rating());
        }
        int whiteElo = 0;
        if (!state.whiteCpu()) {
            Optional<ChessPlayer.CachedPlayer> white = this.queryPlayer(state.whiteId(), handle);
            if (white.isPresent()) {
                whiteElo = white.get().rating();
            }
            this.updatePlayer(handle, state.whiteId(), null);
        }
        int blackElo = 0;
        if (!state.blackCpu()) {
            Optional<ChessPlayer.CachedPlayer> black = this.queryPlayer(state.blackId(), handle);
            if (black.isPresent()) {
                blackElo = black.get().rating();
            }
            this.updatePlayer(handle, state.blackId(), null);
        }
        return new EloChange(whiteElo, 0, blackElo, 0);
    }

    private void updatePlayer(Handle handle, UUID playerId, @Nullable Elo.RatingData ratingData) {
        Optional<ChessPlayer.CachedPlayer> existing = this.queryPlayer(playerId, handle);
        Optional<Player> player = Optional.ofNullable(Bukkit.getPlayer((UUID)playerId));
        String username = player.map(Player::getName).orElseGet(() -> existing.map(c -> PlainTextComponentSerializer.plainText().serialize(c.name())).orElseGet(() -> Objects.requireNonNull(Bukkit.getOfflinePlayer((UUID)playerId).getName(), "name")));
        Component displayName = player.map(Player::displayName).orElseGet(() -> existing.map(ChessPlayer.CachedPlayer::displayName).orElseGet(() -> Component.text((String)username)));
        if (ratingData == null) {
            ratingData = existing.map(ChessPlayer.CachedPlayer::ratingData).orElseGet(Elo.RatingData::newPlayer);
        }
        ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(this.queries.query(existing.isEmpty() ? "insert_player" : "update_player")).bind("id", playerId)).bind("username", username)).bind("displayname", (Object)displayName)).bind("rating", ratingData.rating())).bind("peak_rating", ratingData.peakRating())).bind("rated_matches", ratingData.matches())).execute();
        this.playerCache.put((Object)playerId, CompletableFuture.completedFuture(new ChessPlayer.CachedPlayer(playerId, (Component)Component.text((String)username), displayName, ratingData.rating(), ratingData.peakRating(), ratingData.matches())));
    }

    private static Comparator<GameState> newestFirst() {
        return Comparator.comparing(state -> Objects.requireNonNull(state.lastUpdated(), "lastUpdated")).reversed();
    }

    public static Database init(ChessCraft plugin) {
        plugin.getSLF4JLogger().info("Initializing database...");
        SQLDrivers.loadFrom(Database.class.getClassLoader());
        DatabaseSettings settings = plugin.config().databaseSettings();
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(settings.type == DatabaseSettings.DatabaseType.H2 ? Database.h2Url(plugin) : settings.url);
        hikariConfig.setUsername(settings.type == DatabaseSettings.DatabaseType.H2 ? "" : settings.username);
        hikariConfig.setPassword(settings.type == DatabaseSettings.DatabaseType.H2 ? "" : settings.password);
        hikariConfig.setPoolName("ChessCraft-HikariPool");
        hikariConfig.setThreadFactory(Database.threadFactory(plugin, "ChessCraft-Hikari-%d"));
        hikariConfig.setMaximumPoolSize(settings.connectionPool.maximumPoolSize);
        hikariConfig.setMinimumIdle(settings.connectionPool.minimumIdle);
        hikariConfig.setMaxLifetime(settings.connectionPool.maximumLifetime);
        hikariConfig.setKeepaliveTime(settings.connectionPool.keepaliveTime);
        hikariConfig.setConnectionTimeout(settings.connectionPool.connectionTimeout);
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        Flyway flyway = Flyway.configure((ClassLoader)Database.class.getClassLoader()).baselineVersion("0").baselineOnMigrate(true).locations(new String[]{"queries/migrations/mysql"}).dataSource((DataSource)dataSource).validateMigrationNaming(true).validateOnMigrate(true).load();
        flyway.migrate();
        Jdbi jdbi = (Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)Jdbi.create((DataSource)dataSource).registerColumnMapper((ColumnMapper)new TimeControlColumnMapper())).registerArgument((ArgumentFactory)new TimeControlColumnMapper())).registerColumnMapper((ColumnMapper)new TimeControlSettingsColumnMapper())).registerArgument((ArgumentFactory)new TimeControlSettingsColumnMapper())).registerColumnMapper((ColumnMapper)new ComponentColumnMapper())).registerArgument((ArgumentFactory)new ComponentColumnMapper())).registerColumnMapper((ColumnMapper)new MoveListColumnMapper())).registerArgument((ArgumentFactory)new MoveListColumnMapper())).registerRowMapper((RowMapper)new GameStateRowMapper())).registerColumnMapper((ColumnMapper)new NativeUUIDColumnMapper())).registerColumnMapper((ColumnMapper)new FenColumnMapper())).registerArgument((ArgumentFactory)new FenColumnMapper())).registerRowMapper((RowMapper)new CachedPlayerRowMapper());
        plugin.getSLF4JLogger().info("Done.");
        return new Database(plugin, dataSource, jdbi);
    }

    private static String h2Url(ChessCraft plugin) {
        return "jdbc:h2:" + plugin.getDataFolder().getAbsolutePath() + "/database;MODE=MySQL";
    }

    private record EloChange(int whiteElo, int whiteChange, int blackElo, int blackChange) {
    }
}

