/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.data.piece;

import net.kyori.adventure.text.format.NamedTextColor;

public enum PieceColor {
    WHITE("w", NamedTextColor.WHITE),
    BLACK("b", NamedTextColor.BLACK);

    private final String abbreviation;
    private final NamedTextColor textColor;

    private PieceColor(String abbreviation, NamedTextColor textColor) {
        this.abbreviation = abbreviation;
        this.textColor = textColor;
    }

    public NamedTextColor textColor() {
        return this.textColor;
    }

    public static PieceColor decode(String s) {
        for (PieceColor value : PieceColor.values()) {
            if (!value.abbreviation.equals(s)) continue;
            return value;
        }
        throw new IllegalArgumentException(s);
    }

    public PieceColor other() {
        return this == WHITE ? BLACK : WHITE;
    }

    public String encode() {
        return this.abbreviation;
    }
}

