/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.data;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.data.Vec3d;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.ScalarSerializer;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;

@DefaultQualifier(value=NonNull.class)
public record Vec3i(int x, int y, int z) {
    public static final ScalarSerializer<Vec3i> SERIALIZER = new Serializer();
    public static final Vec3i ZERO = new Vec3i(0, 0, 0);

    public Location toLocation(World world) {
        return new Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    public static Vec3i fromBlockLocation(Location loc) {
        return new Vec3i(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public Vec3i add(int x, int y, int z, int scale) {
        return new Vec3i(this.x + x * scale, this.y + y * scale, this.z + z * scale);
    }

    public Vec3i add(int x, int y, int z) {
        return new Vec3i(this.x + x, this.y + y, this.z + z);
    }

    public Vec3i add(Vec3i vec, int scale) {
        return new Vec3i(this.x + vec.x * scale, this.y + vec.y * scale, this.z + vec.z * scale);
    }

    public Vec3i add(Vec3i vec) {
        return new Vec3i(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vec3i mult(int xFactor, int yFactor, int zFactor) {
        return new Vec3i(this.x * xFactor, this.y * yFactor, this.z * zFactor);
    }

    public Vec3d asVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    private static final class Serializer
    extends ScalarSerializer<Vec3i> {
        private Serializer() {
            super(TypeToken.get(Vec3i.class));
        }

        @Override
        public Vec3i deserialize(Type type, Object obj) throws SerializationException {
            String[] split = obj.toString().split(" ");
            int x = Serializer.tryParse(split[0]);
            int y = Serializer.tryParse(split[1]);
            int z = Serializer.tryParse(split[2]);
            return new Vec3i(x, y, z);
        }

        private static int tryParse(String s) throws SerializationException {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new SerializationException(ex);
            }
        }

        @Override
        protected Object serialize(Vec3i item, Predicate<Class<?>> typeSupported) {
            return item.x() + " " + item.y() + " " + item.z();
        }
    }
}

