/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.data;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.bukkit.Location;
import org.bukkit.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.ScalarSerializer;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;

@DefaultQualifier(value=NonNull.class)
public record Vec3d(double x, double y, double z) {
    public static final ScalarSerializer<Vec3d> SERIALIZER = new Serializer();
    public static final Vec3d ZERO = new Vec3d(0.0, 0.0, 0.0);

    public Location toLocation(World world) {
        return new Location(world, this.x, this.y, this.z);
    }

    public static Vec3d fromBlockLocation(Location loc) {
        return new Vec3d(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public Vec3d add(double x, double y, double z, double scale) {
        return new Vec3d(this.x + x * scale, this.y + y * scale, this.z + z * scale);
    }

    public Vec3d add(double x, double y, double z) {
        return new Vec3d(this.x + x, this.y + y, this.z + z);
    }

    public Vec3d add(Vec3d vec, double scale) {
        return new Vec3d(this.x + vec.x * scale, this.y + vec.y * scale, this.z + vec.z * scale);
    }

    public Vec3d add(Vec3d vec) {
        return new Vec3d(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vec3d mult(double xFactor, double yFactor, double zFactor) {
        return new Vec3d(this.x * xFactor, this.y * yFactor, this.z * zFactor);
    }

    public Vec3d asVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    private static final class Serializer
    extends ScalarSerializer<Vec3d> {
        private Serializer() {
            super(TypeToken.get(Vec3d.class));
        }

        @Override
        public Vec3d deserialize(Type type, Object obj) throws SerializationException {
            String[] split = obj.toString().split(" ");
            double x = Serializer.tryParse(split[0]);
            double y = Serializer.tryParse(split[1]);
            double z = Serializer.tryParse(split[2]);
            return new Vec3d(x, y, z);
        }

        private static double tryParse(String s) throws SerializationException {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                throw new SerializationException(ex);
            }
        }

        @Override
        protected Object serialize(Vec3d item, Predicate<Class<?>> typeSupported) {
            return item.x() + " " + item.y() + " " + item.z();
        }
    }
}

