/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.data;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.joml.Quaternionf;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.ScalarSerializer;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;

@DefaultQualifier(value=NonNull.class)
public record Rotation(double x, double y, double z, double w) {
    public static final ScalarSerializer<Rotation> SERIALIZER = new Serializer();
    public static final Rotation DEFAULT = new Rotation(0.0, 0.0, 0.0, 1.0);

    public Quaternionf asQuaternionf() {
        return new Quaternionf(this.x, this.y, this.z, this.w);
    }

    private static final class Serializer
    extends ScalarSerializer<Rotation> {
        private Serializer() {
            super(TypeToken.get(Rotation.class));
        }

        @Override
        public Rotation deserialize(Type type, Object obj) throws SerializationException {
            String[] split = obj.toString().split(" ");
            double x = Serializer.tryParse(split[0]);
            double y = Serializer.tryParse(split[1]);
            double z = Serializer.tryParse(split[2]);
            double w = Serializer.tryParse(split[3]);
            return new Rotation(x, y, z, w);
        }

        private static double tryParse(String s) throws SerializationException {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                throw new SerializationException(ex);
            }
        }

        @Override
        protected Object serialize(Rotation item, Predicate<Class<?>> typeSupported) {
            return item.x() + " " + item.y() + " " + item.z() + " " + item.w();
        }
    }
}

