/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.BoardStateHolder;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.data.BoardPosition;
import xyz.jpenilla.chesscraft.data.piece.Piece;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;

public record Fen(String fenString, Piece[][] pieces, PieceColor nextMove) implements BoardStateHolder
{
    public static final Fen STARTING_FEN = Fen.read("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");

    @Override
    public @Nullable Piece piece(BoardPosition pos) {
        return this.pieces[pos.rank()][pos.file()];
    }

    public static Fen read(String fenString) {
        Piece[][] pieces = ChessBoard.initBoard();
        String[] arr = fenString.split(" ");
        String positions = arr[0];
        PieceColor nextMove = PieceColor.decode(arr[1]);
        String[] ranks = positions.split("/");
        for (int rank = 0; rank < ranks.length; ++rank) {
            String rankString = ranks[rank];
            int file = 0;
            for (char c : rankString.toCharArray()) {
                try {
                    int empty = Integer.parseInt(String.valueOf(c));
                    for (int i = 0; i < empty; ++i) {
                        pieces[rank][file + i] = null;
                    }
                    file += empty;
                }
                catch (NumberFormatException ex) {
                    pieces[rank][file] = Piece.decode(String.valueOf(c));
                    ++file;
                }
            }
        }
        return new Fen(fenString, pieces, nextMove);
    }

    public Map<IntIntPair, Piece> pawnPositions() {
        HashMap<IntIntPair, Piece> map = new HashMap<IntIntPair, Piece>();
        for (int i = 0; i < this.pieces.length; ++i) {
            Piece[] slice = this.pieces[i];
            for (int i1 = 0; i1 < slice.length; ++i1) {
                Piece piece = slice[i1];
                if (piece == null || piece.type() != PieceType.PAWN) continue;
                map.put(IntIntPair.of((int)i, (int)i1), piece);
            }
        }
        return Map.copyOf(map);
    }

    public Reference2IntMap<PieceType> pieceTotals() {
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        map.defaultReturnValue(0);
        Piece[][] pieceArray = this.pieces;
        int n = pieceArray.length;
        for (int j = 0; j < n; ++j) {
            Piece[] slice;
            for (Piece piece : slice = pieceArray[j]) {
                if (piece == null) continue;
                map.mergeInt((Object)piece.type(), 1, (i, $) -> i + 1);
            }
        }
        return Reference2IntMaps.unmodifiable((Reference2IntMap)map);
    }

    public static final class JsonSerializer
    implements com.google.gson.JsonSerializer<Fen>,
    JsonDeserializer<Fen> {
        public Fen deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Fen.read(json.getAsString());
        }

        public JsonElement serialize(Fen src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.fenString);
        }
    }
}

