/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.config;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.bukkit.Color;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.ScalarSerializer;

@DefaultQualifier(value=NonNull.class)
final class RGBAHexBukkitColorSerializer
extends ScalarSerializer<Color> {
    public RGBAHexBukkitColorSerializer() {
        super(Color.class);
    }

    @Override
    public Color deserialize(Type type, Object obj) {
        return Color.fromARGB((int)RGBAHexBukkitColorSerializer.parseHex(obj.toString()));
    }

    @Override
    protected Object serialize(Color item, Predicate<Class<?>> typeSupported) {
        return String.format("#%08X", RGBAHexBukkitColorSerializer.argbToRgba(item.asARGB()));
    }

    public static int parseHex(String color) {
        int rgba = (int)Long.parseLong(color.replace("#", ""), 16);
        if (color.length() == 9) {
            return RGBAHexBukkitColorSerializer.rgbaToArgb(rgba);
        }
        return rgba;
    }

    public static int argbToRgba(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static int rgbaToArgb(int color) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }
}

