/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.config;

import io.papermc.paper.datacomponent.DataComponentTypes;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.ChessCraft;
import xyz.jpenilla.chesscraft.PieceHandler;
import xyz.jpenilla.chesscraft.data.piece.Piece;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.ConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.SerializationException;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.serialize.TypeSerializer;

public interface PieceOptions {
    public static final Serializer SERIALIZER = new Serializer();

    public PieceHandler createHandler(ChessCraft var1);

    public Mode mode();

    public static final class Serializer
    implements TypeSerializer<PieceOptions> {
        private static final String MODE_FIELD_NAME = "mode";

        private Serializer() {
        }

        @Override
        public PieceOptions deserialize(Type type, ConfigurationNode node) throws SerializationException {
            Mode mode = node.node(MODE_FIELD_NAME).get(Mode.class);
            if (mode == null) {
                throw new SerializationException("Missing mode, should be one of: " + Arrays.toString((Object[])Mode.values()));
            }
            return node.get(mode.type);
        }

        @Override
        public void serialize(Type type, @Nullable PieceOptions obj, ConfigurationNode node) throws SerializationException {
            if (obj == null) {
                throw new SerializationException("null");
            }
            Mode mode = obj.mode();
            node.node(MODE_FIELD_NAME).set((Object)mode);
            node.set(mode.type, (Object)obj);
        }
    }

    @ConfigSerializable
    public static final class PlayerHead
    implements PieceOptions {
        private Map<PieceType, String> white = Map.of(PieceType.PAWN, "4b7aa4969ae3df8334958c212050be343854303767c29d1a1d11c4ac7b7b53d4", PieceType.BISHOP, "4ddacb1907d3ef3f304210b4f9ab75bd4fc1c9f21b25350904d00cd949f19388", PieceType.KNIGHT, "5a550c4f2626f47a9270bd82ee8ce70189ff2941900ac8934dcfe88f2d2181d2", PieceType.ROOK, "7ca26c1c0e19b736ba22f7b31157af920fed61830bd20471b4a886ec971c6323", PieceType.QUEEN, "c33b3ce86d571690b19f5d6d7aa0a721eec70a77962730c771a0815d71503899", PieceType.KING, "209b3d23a7af275a56402123428186e52965ca9373336ddc112792b415aba0a0");
        private Map<PieceType, String> black = Map.of(PieceType.PAWN, "c108c58582bcf2166cd2c0858c73b0af5d1b081f9d628c1b076972c6eb6f0e30", PieceType.BISHOP, "cf9dc78ddc4d732f5e3ed634f74b3ed0b811ed6d52f38c13f2f6db3e99ac084f", PieceType.KNIGHT, "8c5decd64c2324945e9214eed2297eddb626c436543fbd413930f12874f2b801", PieceType.ROOK, "2817755e0a13d5460d183130a5fcdd2e5c38e7292bcd6ef5fdc990501812ac39", PieceType.QUEEN, "a62cfaf38deaee3d08d965ce6dc580c8ccd75d3b14d1bfeb4e093726b6c7b1e2", PieceType.KING, "7ec2822c66ea3a523a8b3c6820580c8c44fdf373b5dc3f55f70028d6cf6d2e44");

        public String texture(Piece piece) {
            if (piece.color() == PieceColor.WHITE) {
                return this.white.get((Object)piece.type());
            }
            return this.black.get((Object)piece.type());
        }

        @Override
        public PieceHandler createHandler(ChessCraft plugin) {
            return new PieceHandler.PlayerHead(this);
        }

        @Override
        public Mode mode() {
            return Mode.PLAYER_HEAD;
        }
    }

    @ConfigSerializable
    public static final class ItemFrame
    implements PieceOptions {
        private Map<PieceType, Double> heightOffsets = Map.of(PieceType.PAWN, -0.71875, PieceType.BISHOP, -0.21875, PieceType.KNIGHT, -0.5625, PieceType.ROOK, -0.625, PieceType.QUEEN, -0.25, PieceType.KING, 0.0);

        public double heightOffset(PieceType type) {
            return this.heightOffsets.getOrDefault((Object)type, 0.0);
        }

        private Key itemModel(Piece piece) {
            String type = piece.type().name().toLowerCase(Locale.ROOT);
            if (piece.color() == PieceColor.WHITE) {
                return Key.key((String)"chesscraft", (String)("chess_" + type + "_white"));
            }
            return Key.key((String)"chesscraft", (String)("chess_" + type + "_black"));
        }

        public ItemStack item(Piece piece) {
            ItemStack stack = ItemStack.of((Material)Material.PAPER);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel(piece));
            return stack;
        }

        @Override
        public PieceHandler createHandler(ChessCraft plugin) {
            return new PieceHandler.ItemFrame(this);
        }

        @Override
        public Mode mode() {
            return Mode.ITEM_FRAME;
        }
    }

    @ConfigSerializable
    public static final class DisplayEntity
    implements PieceOptions {
        private Map<PieceType, Double> heights = Map.of(PieceType.PAWN, 1.28125, PieceType.BISHOP, 1.78125, PieceType.KNIGHT, 1.4375, PieceType.ROOK, 1.375, PieceType.QUEEN, 1.75, PieceType.KING, 2.0);

        private Key itemModel(Piece piece) {
            String type = piece.type().name().toLowerCase(Locale.ROOT);
            if (piece.color() == PieceColor.WHITE) {
                return Key.key((String)"chesscraft", (String)("chess_" + type + "_white"));
            }
            return Key.key((String)"chesscraft", (String)("chess_" + type + "_black"));
        }

        public ItemStack item(Piece piece) {
            ItemStack stack = ItemStack.of((Material)Material.PAPER);
            stack.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel(piece));
            return stack;
        }

        public double height(PieceType type) {
            return this.heights.getOrDefault((Object)type, 2.0);
        }

        @Override
        public PieceHandler createHandler(ChessCraft plugin) {
            return new PieceHandler.DisplayEntity(plugin, this);
        }

        @Override
        public Mode mode() {
            return Mode.DISPLAY_ENTITY;
        }
    }

    public static enum Mode {
        DISPLAY_ENTITY(DisplayEntity.class),
        ITEM_FRAME(ItemFrame.class),
        PLAYER_HEAD(PlayerHead.class);

        private final Class<? extends PieceOptions> type;

        private Mode(Class<? extends PieceOptions> type) {
            this.type = type;
        }
    }
}

