/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.config;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.ChessBoard;
import xyz.jpenilla.chesscraft.ChessGame;
import xyz.jpenilla.chesscraft.ChessPlayer;
import xyz.jpenilla.chesscraft.GameState;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.data.piece.PieceColor;
import xyz.jpenilla.chesscraft.data.piece.PieceType;
import xyz.jpenilla.chesscraft.db.Database;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.util.OptionTagResolver;

@ConfigSerializable
public final class Messages {
    private String checkmate = "<winner_color>\u265a</winner_color><winner_displayname> <green>beat <loser_color>\u265a</loser_color></green><loser_displayname><green> by checkmate!";
    private String stalemate = "<black>\u265a</black><black_displayname> <green>ended in a stalemate with <white>\u265a</white></green><white_displayname><green>!";
    private String drawByRepetition = "<black>\u265a</black><black_displayname> <green>ended in a draw by repetition with <white>\u265a</white></green><white_displayname><green>!";
    private String drawByFiftyMoveRule = "<black>\u265a</black><black_displayname> <green>ended in a draw by the fifty move rule with <white>\u265a</white></green><white_displayname><green>!";
    private String forfeit = "<loser_color>\u265a</loser_color><loser_displayname> <green>forfeited to <winner_color>\u265a</winner_color></green><winner_displayname><green>!";
    private String boardAlreadyExists = "<red>A board with the name <white><name></white> already exists!</red> <white>Use <gray><hover:show_text:'<green>Click to run'><click:run_command:'/chess delete_board <name>'>/chess delete_board <name></gray> to delete it first if you want to replace it.";
    private String boardCreated = "<green>Successfully created board</green><gray>:</gray> <name>";
    private String boardDeleted = "<green>Successfully <red>deleted</red> board</green><gray>:</gray> <name>";
    private String noSuchBoard = "No board exists with the name '<name>'";
    private String noMatchToCancel = "<red>No match to cancel at board '<name>'.";
    private String boardOccupied = "<red>The <name> board is currently occupied!";
    private String challengeSent = "<green>Challenge has been sent! </green><opponent_displayname><green> has 30 seconds to accept.";
    private String challengeReceived = "<green>You have been challenged to Chess by </green><challenger_displayname><green>! They chose to be <challenger_color><challenger_color_name></challenger_color>.\nTime controls<gray>:</gray> <white><time_control></white>\nType <white><click:run_command:'/chess accept'><hover:show_text:'<green>Click to run'>/chess accept</white> to accept. Challenge expires in 30 seconds.";
    private String noTimeControls = "None";
    private String resumeChallengeReceived = "<green>You have been challenged to resume your match with </green><challenger_color>\u265a</challenger_color><challenger_displayname><green>!\nTime controls<gray>:</gray> <white><time_control></white>\nType <white><click:run_command:'/chess accept'><hover:show_text:'<green>Click to run'>/chess accept</white> to accept. Challenge expires in 30 seconds.";
    private String noPendingChallenge = "<red>You do not have an incoming challenge!";
    private String challengeDenied = "<opponent_displayname><red> denied your challenge.";
    private String challengeDeniedFeedback = "<green>Denied </green><challenger_displayname>'s <green>challenge.";
    private String alreadyInGame = "<red>You are already in an active match.";
    private String opponentAlreadyInGame = "<opponent_displayname><red> is already in an active match.";
    private String matchStarted = "<green>Match has started!";
    private String matchResumed = "<green>Match has resumed!";
    private String mustBeInMatch = "<red>You must be in a match to use this command.";
    private String nextPromotionSet = "<green>Your next pawn to reach the 1/8 rank will promote to <type>, instead of the default QUEEN.";
    private String cpuThinking = "<italic><cpu_color>\u265a</cpu_color><gray>CPU is thinking...";
    private String madeMove = "<player_color>\u265a</player_color><player_displayname><gray>:</gray> <move>";
    private String notInThisGame = "<red>You are not a player in this match.";
    private String notYourMove = "<red>Not your move.";
    private String chessEngineProcessing = "<red>Chess engine is currently processing, please try again shortly.";
    private String notYourPiece = "<red>Not your piece.";
    private String invalidMove = "<red>Invalid move.";
    private String showingLegalMoves = "Highlighting of legal moves<gray>:</gray> <on_off>";
    private String timeDisplay = "<opponent_color>\u265a</opponent_color><opponent_time> <gray>|</gray> <player_color>\u265a</player_color><player_time>";
    private String invalidTimeControl = "Invalid time control '<input>', expected format is '<time>[:<increment>]'";
    private String ranOutOfTime = "<player_color>\u265a</player_color><player_displayname> ran out of time!";
    private String resetBoard = "<green>Successfully reset board '<name>'.";
    private String matchCancelled = "<red>Match cancelled.";
    private String pauseProposedSender = "<opponent_color>\u265a</opponent_color><opponent_displayname> has been notified that you wish to pause the match.";
    private String pauseProposedRecipient = "<hover:show_text:'Click to accept'><click:run_command:'/chess accept_pause'><opponent_color>\u265a</opponent_color><opponent_displayname> has proposed a pause on the match. Use <white>/chess accept_pause</white> to accept.";
    private String pausedMatch = "<green>Match has been paused.";
    private String noPauseProposed = "<red>Your match does not have a pause proposed. Use /chess pause_match to propose one.";
    private String opponentOffline = "<red><opponent_name> is not online!";
    private String noSuchMatch = "<red>There is no match recorded with the id <match_id>.";
    private String noPausedMatch = "<red>There is no paused match with the id <match_id>";
    private String noPausedMatches = "<red>No paused matches found.";
    private String noCompleteMatches = "<red>No complete matches found.";
    private String youAreNotInThisMatch = "<red>You are not a player in that match.";
    private String pausedMatchInfo = "<click:suggest_command:'/chess resume_match <match_id> '><white>\u265a</white><white_displayname> <i><gray>vs</i> <black>\u265a</black><black_displayname> <gray><i><time></gray> <export_button>";
    private String completeMatchInfo = "<white>\u265a</white><white_displayname> <i><gray>vs</i> <black>\u265a</black><black_displayname><gray>:</gray> <result><rating_change> <gray><i><time></gray> <export_button>";
    private String exportButton = "<hover:show_text:'Click to export match in PGN format'><click:run_command:'/chess export_match <match_id>'><green>\u2193";
    private String cannotExportIncomplete = "<red>You do not have permission to export incomplete matches.";
    private String cannotExportOthers = "<red>You do not have permission to export matches that you are not a participant in.";
    private String clickToCopyPgn = "<green>Click to copy exported PGN.";
    private String leaderboardHeader = "<green><bold>ChesCraft server leaderboard";
    private String pausedMatchesHeader = "<green><bold>Paused matches for <displayname>";
    private String matchHistoryHeader = "<green><bold>Match history</green> <displayname> <gray>(<white><rating></white>)";
    private String clickForPreviousPage = "Click for previous page";
    private String clickForNextPage = "Click for next page";
    private String pageOutOfRange = "<red>Page <page> is out of range! There are only <pages> pages.";
    private String paginationFooter = "<gray>Page <page><white>/</white><pages> <aqua><buttons>";
    private String nonPlayerMustProvidePlayer = "<red>Must specify the player.";
    private String timestamp = "<month>/<day>/<year_short> <hour>:<minute><am:AM:PM>";
    private String resultWin = "<winner_color>\u265a</winner_color>Checkmate";
    private String resultOutOfTime = "<loser_color>\u265a</loser_color>Out of time";
    private String resultStalemate = "Stalemate";
    private String resultDrawByRepetition = "Draw by repetition";
    private String resultDrawByFiftyMoveRule = "Draw by 50 move rule";
    private String resultForfeit = "<forfeit_color>\u265a</forfeit_color>Forfeit";
    private final transient Component plus = Component.text((char)'+', (TextColor)NamedTextColor.GREEN);
    private final transient Component minus = Component.text((char)'-', (TextColor)NamedTextColor.RED);
    private String on = "<green>On";
    private String off = "<red>Off";

    public Component checkmate(ChessPlayer black, ChessPlayer white, PieceColor winner) {
        ChessPlayer win = winner == PieceColor.BLACK ? black : white;
        ChessPlayer loss = winner == PieceColor.BLACK ? white : black;
        return Messages.parse(this.checkmate, Messages.winLoseTags(win, loss, winner));
    }

    public Component stalemate(ChessPlayer black, ChessPlayer white) {
        return Messages.parse(this.stalemate, Messages.blackWhitePlayerTags(black, white));
    }

    public Component drawByRepetition(ChessPlayer black, ChessPlayer white) {
        return Messages.parse(this.drawByRepetition, Messages.blackWhitePlayerTags(black, white));
    }

    public Component drawByFiftyMoveRule(ChessPlayer black, ChessPlayer white) {
        return Messages.parse(this.drawByFiftyMoveRule, Messages.blackWhitePlayerTags(black, white));
    }

    public Component forfeit(ChessPlayer black, ChessPlayer white, PieceColor forfeited) {
        ChessPlayer win = forfeited == PieceColor.WHITE ? black : white;
        ChessPlayer loss = forfeited == PieceColor.WHITE ? white : black;
        return Messages.parse(this.forfeit, Messages.winLoseTags(win, loss, forfeited.other()));
    }

    public Component boardAlreadyExists(String name) {
        return Messages.parse(this.boardAlreadyExists, Messages.name(name));
    }

    public Component boardCreated(String name) {
        return Messages.parse(this.boardCreated, Messages.name(name));
    }

    public Component boardDeleted(String name) {
        return Messages.parse(this.boardDeleted, Messages.name(name));
    }

    private static TagResolver name(String name) {
        return Placeholder.unparsed((String)"name", (String)name);
    }

    public Component noSuchBoard(String name) {
        return Messages.parse(this.noSuchBoard, Messages.name(name));
    }

    public Component noMatchToCancel(String name) {
        return Messages.parse(this.noMatchToCancel, Messages.name(name));
    }

    public Component boardOccupied(String name) {
        return Messages.parse(this.boardOccupied, Messages.name(name));
    }

    public Component challengeSent(ChessPlayer player, ChessPlayer opponent, PieceColor playerColor) {
        return Messages.parse(this.challengeSent, Messages.playerOpponentTags(player, opponent, playerColor));
    }

    public Component challengeReceived(ChessPlayer challenger, ChessPlayer player, PieceColor challengerColor, @Nullable TimeControlSettings timeControl) {
        return Messages.parse(this.challengeReceived, new TagResolver[]{Messages.challengerPlayerTags(challenger, player, challengerColor), timeControl != null ? Placeholder.unparsed((String)"time_control", (String)timeControl.toString()) : Placeholder.component((String)"time_control", (ComponentLike)Messages.parse(this.noTimeControls, new TagResolver[0]))});
    }

    public Component resumeChallengeReceived(ChessPlayer challenger, ChessPlayer player, PieceColor challengerColor, @Nullable TimeControlSettings timeControl) {
        return Messages.parse(this.resumeChallengeReceived, new TagResolver[]{Messages.challengerPlayerTags(challenger, player, challengerColor), timeControl != null ? Placeholder.unparsed((String)"time_control", (String)timeControl.toString()) : Placeholder.component((String)"time_control", (ComponentLike)Messages.parse(this.noTimeControls, new TagResolver[0]))});
    }

    public Component noPendingChallenge() {
        return Messages.parse(this.noPendingChallenge, new TagResolver[0]);
    }

    public Component challengeDenied(ChessPlayer player, ChessPlayer opponent, PieceColor playerColor) {
        return Messages.parse(this.challengeDenied, Messages.playerOpponentTags(player, opponent, playerColor));
    }

    public Component challengeDeniedFeedback(ChessPlayer challenger, ChessPlayer player, PieceColor challengerColor) {
        return Messages.parse(this.challengeDeniedFeedback, Messages.challengerPlayerTags(challenger, player, challengerColor));
    }

    public Component alreadyInGame() {
        return Messages.parse(this.alreadyInGame, new TagResolver[0]);
    }

    public Component opponentAlreadyInGame(Player opponent) {
        return Messages.parse(this.opponentAlreadyInGame, new TagResolver[]{Placeholder.component((String)"opponent_name", (ComponentLike)opponent.name()), Placeholder.component((String)"opponent_displayname", (ComponentLike)opponent.displayName())});
    }

    public Component matchStarted(ChessBoard board, ChessPlayer white, ChessPlayer black) {
        return Messages.parse(this.matchStarted, new TagResolver[]{Messages.blackWhitePlayerTags(black, white), Placeholder.unparsed((String)"board", (String)board.name())});
    }

    public Component matchResumed(ChessBoard board, ChessPlayer white, ChessPlayer black) {
        return Messages.parse(this.matchResumed, new TagResolver[]{Messages.blackWhitePlayerTags(black, white), Placeholder.unparsed((String)"board", (String)board.name())});
    }

    public Component mustBeInMatch() {
        return Messages.parse(this.mustBeInMatch, new TagResolver[0]);
    }

    public Component nextPromotionSet(PieceType type) {
        return Messages.parse(this.nextPromotionSet, new TagResolver[]{Placeholder.unparsed((String)"type", (String)type.toString())});
    }

    public Component cpuThinking(PieceColor color) {
        return Messages.parse(this.cpuThinking, new TagResolver[]{TagResolver.resolver((String)"cpu_color", (Tag)Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{color.textColor()}))});
    }

    public Component madeMove(ChessPlayer mover, ChessPlayer opponent, PieceColor moverColor, String move) {
        return Messages.parse(this.madeMove, new TagResolver[]{Messages.playerOpponentTags(mover, opponent, moverColor), Placeholder.unparsed((String)"move", (String)move), Placeholder.unparsed((String)"move_from", (String)move.substring(0, 2)), Placeholder.unparsed((String)"move_to", (String)move.substring(2, 4))});
    }

    public Component notInThisGame() {
        return Messages.parse(this.notInThisGame, new TagResolver[0]);
    }

    public Component notYourMove() {
        return Messages.parse(this.notYourMove, new TagResolver[0]);
    }

    public Component chessEngineProcessing() {
        return Messages.parse(this.chessEngineProcessing, new TagResolver[0]);
    }

    public Component notYourPiece() {
        return Messages.parse(this.notYourPiece, new TagResolver[0]);
    }

    public Component invalidMove() {
        return Messages.parse(this.invalidMove, new TagResolver[0]);
    }

    public Component showingLegalMoves(boolean value) {
        return Messages.parse(this.showingLegalMoves, this.onOff(value));
    }

    public Component timeDisplay(ChessGame game, PieceColor playerColor) {
        ChessPlayer player = game.player(playerColor);
        ChessPlayer opp = game.player(playerColor.other());
        return Messages.parse(this.timeDisplay, new TagResolver[]{Messages.playerOpponentTags(player, opp, playerColor), Placeholder.unparsed((String)"player_time", (String)game.time(player).timeLeftString()), Placeholder.unparsed((String)"opponent_time", (String)game.time(opp).timeLeftString())});
    }

    public Component invalidTimeControl(String input) {
        return Messages.parse(this.invalidTimeControl, new TagResolver[]{Placeholder.unparsed((String)"input", (String)input)});
    }

    public Component ranOutOfTime(ChessGame game, PieceColor playerColor) {
        ChessPlayer player = game.player(playerColor);
        ChessPlayer opp = game.player(playerColor.other());
        return Messages.parse(this.ranOutOfTime, Messages.playerOpponentTags(player, opp, playerColor));
    }

    public Component resetBoard(ChessBoard board) {
        return Messages.parse(this.resetBoard, Messages.name(board.name()));
    }

    public Component matchCancelled() {
        return Messages.parse(this.matchCancelled, new TagResolver[0]);
    }

    public Component pauseProposedSender(ChessGame game, PieceColor playerColor) {
        ChessPlayer player = game.player(playerColor);
        ChessPlayer opp = game.player(playerColor.other());
        return Messages.parse(this.pauseProposedSender, Messages.playerOpponentTags(player, opp, playerColor));
    }

    public Component pauseProposedRecipient(ChessGame game, PieceColor playerColor) {
        ChessPlayer player = game.player(playerColor);
        ChessPlayer opp = game.player(playerColor.other());
        return Messages.parse(this.pauseProposedRecipient, Messages.playerOpponentTags(player, opp, playerColor));
    }

    public Component pausedMatch() {
        return Messages.parse(this.pausedMatch, new TagResolver[0]);
    }

    public Component noPauseProposed() {
        return Messages.parse(this.noPauseProposed, new TagResolver[0]);
    }

    public Component opponentOffline(ChessPlayer opponent) {
        return Messages.parse(this.opponentOffline, new TagResolver[]{Placeholder.component((String)"opponent_displayname", (ComponentLike)opponent.displayName()), Placeholder.component((String)"opponent_name", (ComponentLike)opponent.name())});
    }

    public Component noSuchMatch(UUID id) {
        return Messages.parse(this.noSuchMatch, new TagResolver[]{Placeholder.parsed((String)"match_id", (String)id.toString())});
    }

    public Component noPausedMatch(UUID uuid) {
        return Messages.parse(this.noPausedMatch, new TagResolver[]{Placeholder.parsed((String)"match_id", (String)uuid.toString())});
    }

    public Component noPausedMatches() {
        return Messages.parse(this.noPausedMatches, new TagResolver[0]);
    }

    public Component noCompleteMatches() {
        return Messages.parse(this.noCompleteMatches, new TagResolver[0]);
    }

    public Component youAreNotInThisMatch() {
        return Messages.parse(this.youAreNotInThisMatch, new TagResolver[0]);
    }

    public Component pausedMatchInfo(Database db, GameState state, boolean showExportButton) {
        return Messages.parse(this.pausedMatchInfo, new TagResolver[]{Messages.blackWhitePlayerTags(state.blackOffline(db).join(), state.whiteOffline(db).join()), Placeholder.parsed((String)"match_id", (String)state.id().toString()), this.exportButton(showExportButton), this.timeTag(state)});
    }

    public Component completeMatchInfo(Database db, GameState state, UUID perspective, boolean showExportButton) {
        TagResolver.Single ratingChange;
        Objects.requireNonNull(state.result(), "result");
        if (state.result().noRatingChange()) {
            ratingChange = Placeholder.component((String)"rating_change", (ComponentLike)Component.empty());
        } else {
            int eloChange = state.color(perspective) == PieceColor.WHITE ? state.result().whiteEloChange() : state.result().blackEloChange();
            ratingChange = Placeholder.component((String)"rating_change", (ComponentLike)Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.space(), this.plusMinus(eloChange), Component.text((int)Math.abs(eloChange))}));
        }
        return Messages.parse(this.completeMatchInfo, new TagResolver[]{Messages.blackWhitePlayerTags(state.blackOffline(db).join(), state.whiteOffline(db).join()), Placeholder.component((String)"result", (ComponentLike)state.result().describe(this)), Placeholder.parsed((String)"match_id", (String)state.id().toString()), ratingChange, this.exportButton(showExportButton), this.timeTag(state)});
    }

    private TagResolver exportButton(boolean allow) {
        return TagResolver.resolver((String)"export_button", (queue, context) -> {
            if (allow) {
                return Tag.selfClosingInserting((Component)context.deserialize(this.exportButton));
            }
            return Tag.selfClosingInserting((Component)Component.empty());
        });
    }

    public Component cannotExportIncomplete() {
        return Messages.parse(this.cannotExportIncomplete, new TagResolver[0]);
    }

    public Component cannotExportOthers() {
        return Messages.parse(this.cannotExportOthers, new TagResolver[0]);
    }

    public Component clickToCopyPgn() {
        return Messages.parse(this.clickToCopyPgn, new TagResolver[0]);
    }

    public Component leaderboardHeader() {
        return Messages.parse(this.leaderboardHeader, new TagResolver[0]);
    }

    private TagResolver timeTag(GameState state) {
        Timestamp timestamp = Objects.requireNonNull(state.lastUpdated(), "lastUpdated");
        LocalDateTime localDateTime = timestamp.toLocalDateTime();
        int hour = localDateTime.getHour();
        return Placeholder.component((String)"time", (ComponentLike)this.timestamp(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), hour > 12 ? hour - 12 : hour, hour, localDateTime.getMinute(), hour <= 11));
    }

    public Component pausedMatchesHeader(Component username, Component displayName) {
        return Messages.parse(this.pausedMatchesHeader, new TagResolver[]{Placeholder.component((String)"username", (ComponentLike)username), Placeholder.component((String)"displayname", (ComponentLike)displayName)});
    }

    public Component matchHistoryHeader(Component username, Component displayName, int rating) {
        return Messages.parse(this.matchHistoryHeader, new TagResolver[]{Placeholder.component((String)"username", (ComponentLike)username), Placeholder.component((String)"displayname", (ComponentLike)displayName), Placeholder.parsed((String)"rating", (String)String.valueOf(rating))});
    }

    public Component clickForPreviousPage() {
        return Messages.parse(this.clickForPreviousPage, new TagResolver[0]);
    }

    public Component clickForNextPage() {
        return Messages.parse(this.clickForNextPage, new TagResolver[0]);
    }

    public Component pageOutOfRange(int page, int pages) {
        return Messages.parse(this.pageOutOfRange, new TagResolver[]{Placeholder.parsed((String)"page", (String)String.valueOf(page)), Placeholder.parsed((String)"pages", (String)String.valueOf(pages))});
    }

    public Component paginationFooter(int page, int pages, ComponentLike buttons) {
        return Messages.parse(this.paginationFooter, new TagResolver[]{Placeholder.parsed((String)"page", (String)String.valueOf(page)), Placeholder.parsed((String)"pages", (String)String.valueOf(pages)), Placeholder.component((String)"buttons", (ComponentLike)buttons)});
    }

    public Component nonPlayerMustProvidePlayer() {
        return Messages.parse(this.nonPlayerMustProvidePlayer, new TagResolver[0]);
    }

    public Component timestamp(int year, int month, int day, int hour, int hour24, int minute, boolean am) {
        return Messages.parse(this.timestamp, new TagResolver[]{Placeholder.parsed((String)"year", (String)String.valueOf(year)), Placeholder.parsed((String)"year_short", (String)String.valueOf(year).substring(2)), Placeholder.parsed((String)"month", (String)String.valueOf(month)), Placeholder.parsed((String)"day", (String)String.valueOf(day)), Placeholder.parsed((String)"hour", (String)String.valueOf(hour)), Placeholder.parsed((String)"hour_military", (String)String.valueOf(hour24)), Placeholder.parsed((String)"minute", (String)String.format("%02d", minute)), new OptionTagResolver("am", am)});
    }

    public Component resultWin(PieceColor winner) {
        return Messages.parse(this.resultWin, new TagResolver[]{Placeholder.styling((String)"winner_color", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{winner.textColor()}), Placeholder.styling((String)"loser_color", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{winner.other().textColor()})});
    }

    public Component resultOutOfTime(PieceColor loser) {
        return Messages.parse(this.resultOutOfTime, new TagResolver[]{Placeholder.styling((String)"winner_color", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{loser.other().textColor()}), Placeholder.styling((String)"loser_color", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{loser.textColor()})});
    }

    public Component resultStalemate() {
        return Messages.parse(this.resultStalemate, new TagResolver[0]);
    }

    public Component resultDrawByRepetition() {
        return Messages.parse(this.resultDrawByRepetition, new TagResolver[0]);
    }

    public Component resultDrawByFiftyMoveRule() {
        return Messages.parse(this.resultDrawByFiftyMoveRule, new TagResolver[0]);
    }

    public Component resultForfeit(PieceColor forfeited) {
        return Messages.parse(this.resultForfeit, new TagResolver[]{Placeholder.styling((String)"forfeit_color", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{forfeited.textColor()}), Placeholder.styling((String)"winner_color", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{forfeited.other().textColor()})});
    }

    private Component plusMinus(int num) {
        return num > 0 ? this.plus : this.minus;
    }

    public Component on() {
        return Messages.parse(this.on, new TagResolver[0]);
    }

    public Component off() {
        return Messages.parse(this.off, new TagResolver[0]);
    }

    private TagResolver onOff(boolean value) {
        if (value) {
            return Placeholder.component((String)"on_off", (ComponentLike)this.on());
        }
        return Placeholder.component((String)"on_off", (ComponentLike)this.off());
    }

    private static TagResolver playerOpponentTags(ChessPlayer player, ChessPlayer opponent, PieceColor playerColor) {
        return Messages.playerTags(player, "player", opponent, "opponent", playerColor);
    }

    private static TagResolver challengerPlayerTags(ChessPlayer challenger, ChessPlayer player, PieceColor challengerColor) {
        return Messages.playerTags(challenger, "challenger", player, "player", challengerColor);
    }

    private static TagResolver blackWhitePlayerTags(ChessPlayer black, ChessPlayer white) {
        return Messages.playerTags(black, "black", white, "white", PieceColor.BLACK);
    }

    private static TagResolver winLoseTags(ChessPlayer win, ChessPlayer lose, PieceColor winColor) {
        return Messages.playerTags(win, "winner", lose, "loser", winColor);
    }

    public static TagResolver playerTags(ChessPlayer p1, String p1prefix, ChessPlayer p2, String p2prefix, PieceColor p1Color) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{Messages.playerTags(p1, p1prefix, p1Color), Messages.playerTags(p2, p2prefix, p1Color.other())});
    }

    public static TagResolver playerTags(ChessPlayer player, String prefix, PieceColor color) {
        return TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.resolver((String)(prefix + "_color"), (Tag)Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{color.textColor()})), Placeholder.unparsed((String)(prefix + "_color_name"), (String)color.toString()), Placeholder.component((String)(prefix + "_name"), (ComponentLike)player.name()), Placeholder.component((String)(prefix + "_displayname"), (ComponentLike)player.displayName())});
    }

    private static Component parse(String input, TagResolver ... tagResolvers) {
        return MiniMessage.miniMessage().deserialize(input, tagResolvers);
    }
}

