/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.config;

import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.ConfigSerializable;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.objectmapping.meta.Comment;

@DefaultQualifier(value=NonNull.class)
@ConfigSerializable
public class DatabaseSettings {
    @Comment(value="Database type. When using H2, none of the other settings in this section apply.")
    public DatabaseType type = DatabaseType.H2;
    @Comment(value="JDBC URL. Suggested defaults for each DB:\nMariaDB: jdbc:mariadb://host:3306/<database_name>")
    public String url = "jdbc:mariadb://localhost:3306/chesscraft";
    @Comment(value="The connection username.")
    public String username = "username";
    @Comment(value="The connection password.")
    public String password = "password";
    @Comment(value="Settings for the connection pool. This is an advanced configuration that most users won't need to touch.")
    public ConnectionPool connectionPool = new ConnectionPool();

    public DatabaseSettings() {
    }

    public DatabaseSettings(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public static enum DatabaseType {
        H2,
        MARIADB;

    }

    @ConfigSerializable
    public static class ConnectionPool {
        public int maximumPoolSize = 8;
        public int minimumIdle = 8;
        public long maximumLifetime = TimeUnit.MINUTES.toMillis(30L);
        public long keepaliveTime = 0L;
        public long connectionTimeout = TimeUnit.SECONDS.toMillis(30L);
    }
}

