/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.chesscraft.config.NamespacedKeySerializer;
import xyz.jpenilla.chesscraft.config.PieceOptions;
import xyz.jpenilla.chesscraft.config.RGBAHexBukkitColorSerializer;
import xyz.jpenilla.chesscraft.data.Rotation;
import xyz.jpenilla.chesscraft.data.Vec3d;
import xyz.jpenilla.chesscraft.data.Vec3i;
import xyz.jpenilla.chesscraft.dependency.io.leangen.geantyref.TypeToken;
import xyz.jpenilla.chesscraft.dependency.net.kyori.adventure.serializer.configurate4.ConfigurateComponentSerializer;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.CommentedConfigurationNode;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.yaml.NodeStyle;
import xyz.jpenilla.chesscraft.dependency.org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import xyz.jpenilla.chesscraft.display.BoardDisplaySettings;

public final class ConfigHelper {
    public static YamlConfigurationLoader createLoader(Path file) {
        return ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).defaultOptions(options -> options.serializers(serializers -> {
            serializers.register(Vec3i.SERIALIZER);
            serializers.register(Vec3d.SERIALIZER);
            serializers.register(Rotation.SERIALIZER);
            serializers.registerExact(NamespacedKeySerializer.INSTANCE);
            serializers.register(new RGBAHexBukkitColorSerializer());
            serializers.registerExact(PieceOptions.class, PieceOptions.SERIALIZER);
            serializers.registerAll(ConfigurateComponentSerializer.configurate().serializers());
            serializers.registerExact(new TypeToken<BoardDisplaySettings<?>>(){}, new BoardDisplaySettings.Serializer());
        }))).path(file)).build();
    }

    public static <T> T loadConfig(TypeToken<T> configType, Path path, Supplier<T> defaultConfigFactory) {
        try {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                YamlConfigurationLoader loader = ConfigHelper.createLoader(path);
                CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
                return Objects.requireNonNull(node.get(configType));
            }
            return defaultConfigFactory.get();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load config of type '" + configType.getType().getTypeName() + "' from file at '" + String.valueOf(path) + "'.", ex);
        }
    }

    public static <T> T loadConfig(Class<T> configType, Path path) {
        return (T)ConfigHelper.loadConfig(TypeToken.get(configType), path, () -> {
            try {
                return configType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to create instance of type " + configType.getName() + ", does it have a public no args constructor?");
            }
        });
    }

    public static <T> void saveConfig(Path path, TypeToken<T> configType, T config) {
        ConfigHelper.saveConfig(path, config, configType);
    }

    public static void saveConfig(Path path, Object config) {
        ConfigHelper.saveConfig(path, config, null);
    }

    private static void saveConfig(Path path, Object config, @Nullable TypeToken<?> configType) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            YamlConfigurationLoader loader = ConfigHelper.createLoader(path);
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.createNode();
            if (configType != null) {
                node.set((TypeToken)configType, config);
            } else {
                node.set(config);
            }
            loader.save(node);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to save config of type '" + (configType != null ? configType.getType().getTypeName() : config.getClass().getName()) + "' to file at '" + String.valueOf(path) + "'.", ex);
        }
    }
}

