/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.chesscraft.command.parser;

import java.time.Duration;
import java.util.List;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.chesscraft.command.Commands;
import xyz.jpenilla.chesscraft.data.TimeControlSettings;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandContext;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.context.CommandInput;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParseResult;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ArgumentParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.ParserDescriptor;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.parser.standard.DurationParser;
import xyz.jpenilla.chesscraft.dependency.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import xyz.jpenilla.chesscraft.util.ComponentRuntimeException;

@DefaultQualifier(value=NonNull.class)
public final class TimeControlParser
implements ArgumentParser<CommandSender, TimeControlSettings>,
BlockingSuggestionProvider.Strings<CommandSender> {
    private static final ArgumentParser<CommandSender, Duration> DURATION_PARSER = DurationParser.durationParser().parser();
    private static final List<String> SUGGESTIONS = List.of("10m", "5m", "3m", "1m", "15m:10s", "10m:5s", "3m:2s", "2m:1s", "1m:1s");

    public static ParserDescriptor<CommandSender, TimeControlSettings> timeControlParser() {
        return ParserDescriptor.of(new TimeControlParser(), TimeControlSettings.class);
    }

    @Override
    public ArgumentParseResult<TimeControlSettings> parse(CommandContext<CommandSender> commandContext, CommandInput commandInput) {
        String peek = commandInput.readString();
        String[] split = peek.split(":");
        if (split.length != 1 && split.length != 2) {
            return ArgumentParseResult.failure(ComponentRuntimeException.withMessage((ComponentLike)commandContext.get(Commands.PLUGIN).config().messages().invalidTimeControl(peek)));
        }
        ArgumentParseResult<Duration> duration0 = DURATION_PARSER.parse(commandContext, CommandInput.of(split[0]));
        if (duration0.failure().isPresent()) {
            return ArgumentParseResult.failure(duration0.failure().get());
        }
        if (split.length == 2) {
            ArgumentParseResult<Duration> duration1 = DURATION_PARSER.parse(commandContext, CommandInput.of(split[1]));
            if (duration1.failure().isPresent()) {
                return ArgumentParseResult.failure(duration1.failure().get());
            }
            return ArgumentParseResult.success(new TimeControlSettings(duration0.parsedValue().orElseThrow(), duration1.parsedValue().orElseThrow()));
        }
        return ArgumentParseResult.success(new TimeControlSettings(duration0.parsedValue().orElseThrow(), Duration.ofSeconds(0L)));
    }

    public List<String> stringSuggestions(CommandContext<CommandSender> commandContext, CommandInput commandInput) {
        return SUGGESTIONS;
    }
}

